/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.minpack;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.FunctionException;
import ec.tstoolkit.maths.realfunctions.minpack.IEstimationProblem;
import ec.tstoolkit.maths.realfunctions.minpack.IEstimator;

public abstract class AbstractEstimator
implements IEstimator {
    protected double[] m_jacobian;
    protected int m_cols;
    protected int m_rows;
    protected double[] m_residuals;
    protected double m_cost;
    private int m_maxCostEval;
    private int m_costEvaluations;
    private int m_jacobianEvaluations;

    protected AbstractEstimator() {
    }

    public double chiSquare(IEstimationProblem problem) {
        int n = problem.getMeasurementsCount();
        double chi = 0.0;
        for (int i = 0; i < n; ++i) {
            double residual = problem.getResidual(i);
            chi += residual * residual / problem.getMeasurementWheight(i);
        }
        return chi;
    }

    @Override
    public Matrix covariance(IEstimationProblem problem) {
        Matrix cur = this.curvature(problem);
        try {
            return SymmetricMatrix.inverse(cur);
        }
        catch (MatrixException ex) {
            return null;
        }
    }

    @Override
    public Matrix curvature(IEstimationProblem problem) {
        this.updateJacobian(problem);
        int rows = problem.getMeasurementsCount();
        int cols = problem.getParametersCount();
        int Max = cols * rows;
        Matrix jTj = new Matrix(cols, cols);
        for (int i = 0; i < cols; ++i) {
            for (int j = i; j < cols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < Max; k += cols) {
                    sum += this.m_jacobian[k + i] * this.m_jacobian[k + j];
                }
                jTj.set(i, j, sum);
                jTj.set(j, i, sum);
            }
        }
        return jTj;
    }

    @Override
    public abstract void estimate(IEstimationProblem var1);

    public int getCostEvaluations() {
        return this.m_costEvaluations;
    }

    public int getJacobianEvaluations() {
        return this.m_jacobianEvaluations;
    }

    public int getMaxCostEval() {
        return this.m_maxCostEval;
    }

    @Override
    public double[] guessParametersErrors(IEstimationProblem problem) {
        int p;
        int m = problem.getMeasurementsCount();
        if (m <= (p = problem.getParametersCount())) {
            throw new FunctionException("no degrees of freedom");
        }
        double[] errors = new double[p];
        double c = Math.sqrt(this.chiSquare(problem) / (double)(m - p));
        Matrix covar = this.covariance(problem);
        DataBlock diag = covar.diagonal();
        for (int i = 0; i < errors.length; ++i) {
            errors[i] = Math.sqrt(diag.get(i)) * c;
        }
        return errors;
    }

    protected void incrementJacobianEvaluationsCounter() {
        ++this.m_jacobianEvaluations;
    }

    protected void initializeEstimate(IEstimationProblem problem) {
        this.m_costEvaluations = 0;
        this.m_jacobianEvaluations = 0;
        this.m_rows = problem.getMeasurementsCount();
        this.m_cols = problem.getUnboundParametersCount();
        this.m_jacobian = new double[this.m_rows * this.m_cols];
        this.m_residuals = new double[this.m_rows];
        this.m_cost = Double.POSITIVE_INFINITY;
    }

    @Override
    public double rms(IEstimationProblem problem) {
        int n = problem.getMeasurementsCount();
        double criterion = 0.0;
        for (int i = 0; i < n; ++i) {
            double residual = problem.getResidual(i);
            criterion += problem.getMeasurementWheight(i) * residual * residual;
        }
        return Math.sqrt(criterion / (double)n);
    }

    public void setMaxCostEval(int value) {
        this.m_maxCostEval = value;
    }

    protected void updateJacobian(IEstimationProblem problem) {
        int i;
        this.incrementJacobianEvaluationsCounter();
        for (i = 0; i < this.m_jacobian.length; ++i) {
            this.m_jacobian[i] = 0.0;
        }
        int index = 0;
        for (i = 0; i < this.m_rows; ++i) {
            double factor = -Math.sqrt(problem.getMeasurementWheight(i));
            for (int j = 0; j < this.m_cols; ++j) {
                this.m_jacobian[index++] = factor * problem.getMeasurementParialDerivative(i, j);
            }
        }
    }

    protected void updateResidualsAndCost(IEstimationProblem problem) {
        if (++this.m_costEvaluations > this.m_maxCostEval) {
            throw new FunctionException("Maximal number of evaluations exceeded", "MinPack");
        }
        this.m_cost = 0.0;
        int i = 0;
        int index = 0;
        while (i < this.m_rows) {
            double residual = problem.getResidual(i);
            double weight = problem.getMeasurementWheight(i);
            this.m_residuals[i] = Math.sqrt(weight) * residual;
            this.m_cost += weight * residual * residual;
            ++i;
            index += this.m_cols;
        }
        this.m_cost = Math.sqrt(this.m_cost);
    }
}

