/*
 * Decompiled with CFR 0.152.
 */
package jd2.datatypes;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TsMoniker
implements Comparable<TsMoniker> {
    public static final TsMoniker NULL = TsMoniker.create(null, null);
    private final String m_source;
    private final String m_id;

    public static @NonNull TsMoniker create(@Nullable String source, @Nullable String id) throws IllegalArgumentException {
        if (source == null && id == null) {
            return new TsMoniker();
        }
        if (source != null && id != null) {
            return new TsMoniker(source, id);
        }
        throw new IllegalArgumentException();
    }

    public TsMoniker() {
        this.m_source = null;
        this.m_id = null;
    }

    private TsMoniker(String source) {
        this.m_source = source;
        this.m_id = null;
    }

    public TsMoniker(@NonNull String source, @NonNull String id) throws IllegalArgumentException {
        if (source == null || id == null) {
            throw new IllegalArgumentException("source and id cannot be null");
        }
        this.m_source = source;
        this.m_id = id;
    }

    public boolean isAnonymous() {
        return this.m_id == null;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TsMoniker && this.equals((TsMoniker)obj);
    }

    private boolean equals(TsMoniker other) {
        return !this.isAnonymous() && this.m_source.equals(other.m_source) && this.m_id.equals(other.m_id);
    }

    public @Nullable String getId() {
        return this.m_id;
    }

    public @Nullable String getSource() {
        return this.m_source;
    }

    public int hashCode() {
        return !this.isAnonymous() ? 0 ^ this.m_source.hashCode() ^ this.m_id.hashCode() : super.hashCode();
    }

    public String toString() {
        return !this.isAnonymous() ? this.m_source + "<@>" + this.m_id : super.toString();
    }

    @Override
    public int compareTo(TsMoniker o) {
        if (this.isAnonymous()) {
            if (o.isAnonymous()) {
                return Integer.compare(this.hashCode(), o.hashCode());
            }
            return -1;
        }
        if (o.isAnonymous()) {
            return 1;
        }
        int r0 = this.m_source.compareTo(o.m_source);
        return r0 != 0 ? r0 : this.m_id.compareTo(o.m_id);
    }
}

