/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.DStatException;
import ec.tstoolkit.stats.AutoCorrelations;
import ec.tstoolkit.stats.BoxPierceTest;
import ec.tstoolkit.stats.DoornikHansenTest;
import ec.tstoolkit.stats.KurtosisTest;
import ec.tstoolkit.stats.LjungBoxTest;
import ec.tstoolkit.stats.MeanTest;
import ec.tstoolkit.stats.SkewnessTest;
import ec.tstoolkit.stats.StatException;
import ec.tstoolkit.stats.TestofRuns;
import ec.tstoolkit.stats.TestofUpDownRuns;

public class NiidTests {
    private DescriptiveStatistics stats;
    private AutoCorrelations ac;
    private AutoCorrelations ac2;
    private LjungBoxTest m_lb;
    private LjungBoxTest m_lb2;
    private LjungBoxTest m_lbs;
    private BoxPierceTest m_bp;
    private BoxPierceTest m_bp2;
    private BoxPierceTest m_bps;
    private MeanTest m_mean;
    private DoornikHansenTest m_dh;
    private SkewnessTest m_skewness;
    private KurtosisTest m_kurtosis;
    private TestofRuns m_runs;
    private TestofUpDownRuns m_udruns;
    private int m_freq;
    private int m_nhp;
    private int m_k;
    private int m_ks;
    private boolean m_seas;

    public static int calcLBLength(int freq) {
        int n = 0;
        n = freq == 12 ? 24 : (freq == 1 ? 8 : 4 * freq);
        return n;
    }

    public NiidTests(IReadDataBlock data, int freq, int nhp, boolean seas) {
        this.stats = new DescriptiveStatistics(data);
        this.m_freq = freq;
        this.m_seas = seas;
        this.m_nhp = nhp;
        this.ac = new AutoCorrelations(this.stats);
        this.ac.setKMax(NiidTests.calcLBLength(freq <= 1 ? 6 : freq));
        this.calcAC2();
        this.ac2.setKMax(NiidTests.calcLBLength(freq <= 1 ? 6 : freq));
    }

    private void calcAC2() {
        double[] data = this.stats.internalStorage();
        double[] d2 = new double[data.length];
        for (int i = 0; i < d2.length; ++i) {
            double cur = data[i];
            d2[i] = Double.isFinite(cur) ? cur * cur : Double.NaN;
        }
        this.ac2 = new AutoCorrelations(new DataBlock(d2));
        this.ac2.setCorrectedForMean(true);
    }

    public AutoCorrelations getAutoCorrelations() {
        return this.ac;
    }

    public AutoCorrelations getAutoCorrelationsOnSquare() {
        return this.ac2;
    }

    public BoxPierceTest getBoxPierce() {
        if (this.m_bp == null) {
            try {
                int k = this.m_k != 0 ? this.m_k : NiidTests.calcLBLength(this.m_freq);
                this.m_bp = new BoxPierceTest();
                this.m_bp.setHyperParametersCount(this.m_nhp);
                this.m_bp.setLag(1);
                this.m_bp.setK(k);
                this.m_bp.test(this.ac);
            }
            catch (StatException ex) {
                this.m_bp = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_bp.isValid() ? this.m_bp : null;
    }

    public BoxPierceTest getBoxPierceOnSquare() {
        if (this.m_bp2 == null) {
            try {
                int k = this.m_k != 0 ? this.m_k : NiidTests.calcLBLength(this.m_freq);
                this.m_bp2 = new BoxPierceTest();
                this.m_bp2.setHyperParametersCount(this.m_nhp);
                this.m_bp2.setLag(1);
                this.m_bp2.setK(k);
                this.m_bp2.test(this.ac2);
            }
            catch (StatException ex) {
                this.m_bp2 = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_bp2.isValid() ? this.m_bp2 : null;
    }

    public int getFrequency() {
        return this.m_freq;
    }

    public int getHyperParametersCount() {
        return this.m_nhp;
    }

    public int getK() {
        return this.m_k;
    }

    public KurtosisTest getKurtosis() {
        if (this.m_kurtosis == null) {
            try {
                this.m_kurtosis = new KurtosisTest();
                this.m_kurtosis.test(this.stats);
            }
            catch (StatException ex) {
                this.m_kurtosis = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_kurtosis.isValid() ? this.m_kurtosis : null;
    }

    public LjungBoxTest getLjungBox() {
        if (this.m_lb == null) {
            try {
                int k = this.m_k != 0 ? this.m_k : NiidTests.calcLBLength(this.m_freq);
                this.m_lb = new LjungBoxTest();
                this.m_lb.setHyperParametersCount(this.m_nhp);
                this.m_lb.setLag(1);
                this.m_lb.setK(k);
                this.m_lb.test(this.ac);
            }
            catch (StatException ex) {
                this.m_lb = null;
                return null;
            }
        }
        return this.m_lb.isValid() ? this.m_lb : null;
    }

    public LjungBoxTest getLjungBoxOnSquare() {
        if (this.m_lb2 == null) {
            try {
                int k = this.m_k != 0 ? this.m_k : NiidTests.calcLBLength(this.m_freq);
                this.m_lb2 = new LjungBoxTest();
                this.m_lb2.setHyperParametersCount(this.m_nhp);
                this.m_lb2.setLag(1);
                this.m_lb2.setK(k);
                this.m_lb2.test(this.ac2);
            }
            catch (StatException ex) {
                this.m_lb2 = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_lb2.isValid() ? this.m_lb2 : null;
    }

    public MeanTest getMeanTest() {
        if (this.m_mean == null) {
            try {
                this.m_mean = new MeanTest();
                this.m_mean.zeroMean(this.stats);
            }
            catch (StatException ex) {
                this.m_mean = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_mean.isValid() ? this.m_mean : null;
    }

    public DoornikHansenTest getNormalityTest() {
        if (this.m_dh == null) {
            try {
                this.m_dh = new DoornikHansenTest();
                this.m_dh.test(this.stats);
            }
            catch (StatException ex) {
                this.m_dh = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_dh.isValid() ? this.m_dh : null;
    }

    public TestofRuns getRuns() {
        if (this.m_runs == null) {
            try {
                this.m_runs = new TestofRuns();
                this.m_runs.test(this.stats);
            }
            catch (DStatException | StatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_runs.isValid() ? this.m_runs : null;
    }

    public BoxPierceTest getSeasonalBoxPierce() {
        if (!this.m_seas) {
            return null;
        }
        if (this.m_bps == null) {
            try {
                int k = this.m_ks != 0 ? this.m_ks : 2;
                this.m_bps = new BoxPierceTest();
                this.m_bps.setHyperParametersCount(this.m_nhp);
                this.m_bps.setLag(this.m_freq);
                this.m_bps.setK(k);
                this.m_bps.test(this.ac);
            }
            catch (StatException ex) {
                this.m_bps = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_bps.isValid() ? this.m_bps : null;
    }

    public LjungBoxTest getSeasonalLjungBox() {
        if (!this.m_seas) {
            return null;
        }
        if (this.m_lbs == null) {
            try {
                int k = this.m_ks != 0 ? this.m_ks : 2;
                this.m_lbs = new LjungBoxTest();
                this.m_lbs.setHyperParametersCount(this.m_nhp);
                this.m_lbs.setLag(this.m_freq);
                this.m_lbs.setK(k);
                this.m_lbs.test(this.ac);
            }
            catch (StatException ex) {
                this.m_lbs = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_lbs.isValid() ? this.m_lbs : null;
    }

    public int getsK() {
        return this.m_ks;
    }

    public SkewnessTest getSkewness() {
        if (this.m_skewness == null) {
            try {
                this.m_skewness = new SkewnessTest();
                this.m_skewness.test(this.stats);
            }
            catch (StatException ex) {
                this.m_skewness = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_skewness.isValid() ? this.m_skewness : null;
    }

    public DescriptiveStatistics getStatistics() {
        return this.stats;
    }

    public TestofUpDownRuns getUpAndDownRuns() {
        if (this.m_udruns == null) {
            try {
                this.m_udruns = new TestofUpDownRuns();
                this.m_udruns.test(this.stats);
            }
            catch (StatException ex) {
                this.m_udruns = null;
                return null;
            }
            catch (DStatException ex) {
                this.m_runs = null;
                return null;
            }
        }
        return this.m_udruns.isValid() ? this.m_udruns : null;
    }

    public void prepare(int k) {
        this.ac.setKMax(k);
        this.ac2.setKMax(k);
    }

    public void setK(int value) {
        this.m_k = value;
    }

    public void setsK(int value) {
        this.m_ks = value;
    }
}

