/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.modelling.arima.ISeriesScaling;
import ec.tstoolkit.modelling.arima.ModellingContext;

public class UnitSeriesScaling
implements ISeriesScaling {
    private static final double D_MAX = 1.0E8;
    private static final double D_MIN = 1.0E-6;
    private final double dmax_;
    private final double dmin_;

    public UnitSeriesScaling() {
        this.dmin_ = 1.0E-6;
        this.dmax_ = 1.0E8;
    }

    public UnitSeriesScaling(double dmin, double dmax) {
        this.dmin_ = dmin;
        this.dmax_ = dmax;
    }

    @Override
    public boolean process(ModellingContext context) {
        double ymax;
        int i;
        if (context.description.getUnits() != 1.0) {
            return false;
        }
        double[] data = context.description.getY();
        for (i = 0; i < data.length && !Double.isFinite(data[i]); ++i) {
        }
        if (i == data.length) {
            return false;
        }
        double ymin = ymax = data[i++];
        while (i < data.length) {
            if (Double.isFinite(data[i])) {
                double ycur = Math.abs(data[i]);
                if (ycur < ymin) {
                    ymin = ycur;
                } else if (ycur > ymax) {
                    ymax = ycur;
                }
            }
            ++i;
        }
        int k = 0;
        if (ymin == ymax) {
            return false;
        }
        if (ymax < this.dmax_ && ymin > this.dmin_) {
            return true;
        }
        while (ymin > 1000.0) {
            --k;
            ymin /= 1000.0;
        }
        while (ymax < 0.1) {
            ++k;
            ymax *= 1000.0;
        }
        if (k != 0) {
            double factor = 1.0;
            for (i = 0; i < k; ++i) {
                factor *= 1000.0;
            }
            for (i = k; i < 0; ++i) {
                factor /= 1000.0;
            }
            context.description.setUnit(factor);
        }
        return true;
    }

    public double getMax() {
        return this.dmax_;
    }

    public double getMin() {
        return this.dmin_;
    }
}

