/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.timeseries.simplets.TsData;

public class DifferencingResults {
    private final TsData original;
    private final TsData differenced;
    private final boolean mean;

    private static int searchOrder(double[] data, int ifreq) {
        if (ifreq < 6) {
            for (int i = 0; i < ifreq; ++i) {
                if (!(DescriptiveStatistics.cov(i + 1, data) < 0.0)) continue;
                return 1;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                if (!(DescriptiveStatistics.cov(i + 1, data) < 0.0)) continue;
                return 1;
            }
        }
        if (DescriptiveStatistics.cov(ifreq, data) < 0.0) {
            return 1;
        }
        return 2;
    }

    public static DifferencingResults create(TsData input, int delta, boolean mean) {
        boolean bmean;
        int del;
        int ifreq = input.getFrequency().intValue();
        if (delta < 0) {
            del = DifferencingResults.searchOrder(input.internalStorage(), ifreq);
            bmean = del != 2;
        } else {
            del = delta;
            bmean = mean;
        }
        TsData diff = input.delta(1, del);
        if (bmean) {
            DescriptiveStatistics stats = new DescriptiveStatistics(diff);
            diff.apply(x -> x - stats.getAverage());
        }
        return new DifferencingResults(input, diff, bmean);
    }

    public DifferencingResults(TsData orig, TsData diff, boolean mean) {
        this.original = orig;
        this.differenced = diff;
        this.mean = mean;
    }

    public int getDifferencingOrder() {
        return this.original.getLength() - this.differenced.getLength();
    }

    public TsData getRestrictedOriginal() {
        return this.original.fittoDomain(this.differenced.getDomain());
    }

    public TsData getOriginal() {
        return this.original;
    }

    public TsData getDifferenced() {
        return this.differenced;
    }

    public boolean isMean() {
        return this.mean;
    }
}

