/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.IDomain;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.io.Serializable;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class TsDomain
implements IDomain,
Serializable,
Iterable<TsPeriod> {
    private static final long serialVersionUID = 3500593038737276467L;
    private final TsFrequency m_freq;
    private final int m_beg;
    private final int m_c;

    TsDomain(TsFrequency freq, int beg, int count) {
        this.m_freq = freq;
        this.m_beg = beg;
        this.m_c = count;
    }

    public TsDomain(TsFrequency freq, int firstyear, int firstperiod, int count) {
        this(freq, TsPeriod.calcId(freq.intValue(), firstyear, firstperiod), count);
    }

    public TsDomain(TsPeriod start, int count) {
        this(start.getFrequency(), start.id(), count);
    }

    public boolean contains(TsDomain domain) {
        if (this.m_freq != domain.m_freq) {
            throw new TsException("Incompatible frequencies");
        }
        return this.m_beg <= domain.m_beg && this.m_beg + this.m_c >= domain.m_beg + domain.m_c;
    }

    public TsDomain drop(int nfirst, int nlast) {
        return this.extend(-nfirst, -nlast);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TsDomain && this.equals((TsDomain)obj);
    }

    public boolean equals(TsDomain other) {
        return this.m_freq == other.m_freq && this.m_beg == other.m_beg && this.m_c == other.m_c;
    }

    public TsDomain extend(int nbefore, int nafter) {
        int c = Math.max(0, this.m_c + nbefore + nafter);
        return new TsDomain(this.m_freq, this.m_beg - nbefore, c);
    }

    int firstid() {
        return this.m_beg;
    }

    @Override
    public TsPeriod get(int idx) {
        return new TsPeriod(this.m_freq, this.m_beg + idx);
    }

    public TsPeriod getEnd() {
        return new TsPeriod(this.m_freq, this.m_beg + this.m_c);
    }

    public TsFrequency getFrequency() {
        return this.m_freq;
    }

    public int getYearsCount() {
        return this.getLast().getYear() - this.getStart().getYear() + 1;
    }

    public int getFullYearsCount() {
        int start = this.m_beg;
        int ifreq = this.m_freq.intValue();
        int pos = start % ifreq;
        if (pos > 0) {
            start += ifreq - pos;
        }
        int end = this.m_beg + this.m_c;
        end -= end % ifreq;
        return (end - start) / ifreq;
    }

    public TsPeriod getLast() {
        return new TsPeriod(this.m_freq, this.m_beg + this.m_c - 1);
    }

    @Override
    public int getLength() {
        return this.m_c;
    }

    public TsPeriod getStart() {
        return new TsPeriod(this.m_freq, this.m_beg);
    }

    public int startId() {
        return this.m_beg;
    }

    public int hashCode() {
        return this.m_freq.hashCode() + this.m_beg + this.m_c;
    }

    public static TsDomain and(TsDomain l, TsDomain r) {
        if (l == null) {
            return r;
        }
        if (r == null) {
            return l;
        }
        return l.intersection(r);
    }

    public static TsDomain or(TsDomain l, TsDomain r) {
        if (l == null) {
            return l;
        }
        if (r == null) {
            return l;
        }
        return l.union(r);
    }

    public TsDomain intersection(TsDomain d) {
        if (d == this) {
            return this;
        }
        if (d.m_freq != this.m_freq) {
            throw new TsException("Incompatible frequencies");
        }
        int ln = this.m_c;
        int rn = d.m_c;
        int lbeg = this.m_beg;
        int rbeg = d.m_beg;
        int lend = lbeg + ln;
        int rend = rbeg + rn;
        int beg = lbeg <= rbeg ? rbeg : lbeg;
        int end = lend >= rend ? rend : lend;
        return new TsDomain(this.m_freq, beg, Math.max(0, end - beg));
    }

    public boolean isEmpty() {
        return this.m_c == 0;
    }

    @Override
    public Iterator<TsPeriod> iterator() {
        return new TSPeriodIterator(this);
    }

    public Stream<TsPeriod> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public TsDomain move(int nperiods) {
        return new TsDomain(this.m_freq, this.m_beg + nperiods, this.m_c);
    }

    @Override
    public int search(Day day) {
        TsPeriod p = new TsPeriod(this.m_freq);
        p.set(day);
        return this.search(p);
    }

    public int search(TsPeriod p) {
        if (p.getFrequency() != this.m_freq) {
            return -1;
        }
        int id = p.id();
        if ((id -= this.m_beg) < 0 || id >= this.m_c) {
            return -1;
        }
        return id;
    }

    public TsDomain select(TsPeriodSelector ps) {
        if (this.m_c == 0) {
            return this;
        }
        int nf = 0;
        int nl = 0;
        PeriodSelectorType type = ps.getType();
        if (type == PeriodSelectorType.None) {
            nf = this.m_c;
        } else if (type == PeriodSelectorType.First) {
            int nobs = ps.getN0();
            nl = this.m_c - nobs;
        } else if (type == PeriodSelectorType.Last) {
            int nobs = ps.getN1();
            nf = this.m_c - nobs;
        } else if (type == PeriodSelectorType.Excluding) {
            nf = ps.getN0();
            nl = ps.getN1();
            if (nf < 0) {
                nf = -nf * this.m_freq.intValue();
            }
            if (nl < 0) {
                nl = -nl * this.m_freq.intValue();
            }
        } else {
            int c;
            TsPeriod cur;
            Day d;
            if (type == PeriodSelectorType.From || type == PeriodSelectorType.Between) {
                d = ps.getD0();
                cur = new TsPeriod(this.m_freq);
                cur.set(d);
                c = cur.id() - this.m_beg;
                if (c >= this.m_c) {
                    nf = this.m_c;
                } else if (c >= 0) {
                    nf = cur.firstday().isBefore(d) ? c + 1 : c;
                }
            }
            if (type == PeriodSelectorType.To || type == PeriodSelectorType.Between) {
                d = ps.getD1();
                cur = new TsPeriod(this.m_freq);
                cur.set(d);
                c = cur.id() - this.m_beg;
                if (c < 0) {
                    nl = this.m_c;
                } else if (c < this.m_c) {
                    nl = cur.lastday().isAfter(d) ? this.m_c - c : this.m_c - c - 1;
                }
            }
        }
        if (nf < 0) {
            nf = 0;
        }
        if (nl < 0) {
            nl = 0;
        }
        return new TsDomain(this.m_freq, this.m_beg + nf, this.m_c - nf - nl);
    }

    public TsDomain union(TsDomain d) {
        if (d == this) {
            return this;
        }
        if (d.m_freq != this.m_freq) {
            return null;
        }
        int ln = this.m_c;
        int rn = d.m_c;
        int lbeg = this.m_beg;
        int rbeg = d.m_beg;
        int lend = lbeg + ln;
        int rend = rbeg + rn;
        int beg = lbeg <= rbeg ? lbeg : rbeg;
        int end = lend >= rend ? lend : rend;
        return new TsDomain(this.m_freq, beg, end - beg);
    }

    public TsDomain changeFrequency(TsFrequency newfreq, boolean complete) {
        int nfreq;
        int freq = this.m_freq.intValue();
        if (freq == (nfreq = newfreq.intValue())) {
            return this;
        }
        if (freq > nfreq) {
            if (freq % nfreq != 0) {
                return null;
            }
            int nconv = freq / nfreq;
            int z0 = 0;
            int nbeg = this.m_beg / nconv;
            int n0 = nconv;
            int n1 = nconv;
            if (this.m_beg % nconv != 0) {
                if (complete) {
                    if (this.m_beg > 0) {
                        ++nbeg;
                        z0 = nconv - this.m_beg % nconv;
                    } else {
                        z0 = -this.m_beg % nconv;
                    }
                } else {
                    if (this.m_beg < 0) {
                        --nbeg;
                    }
                    n0 = (nbeg + 1) * nconv - this.m_beg;
                }
            }
            int end = this.m_beg + this.m_c;
            int nend = end / nconv;
            if (end % nconv != 0) {
                if (complete) {
                    if (end < 0) {
                        --nend;
                    }
                } else {
                    if (end > 0) {
                        ++nend;
                    }
                    n1 = end - (nend - 1) * nconv;
                }
            }
            int n = nend - nbeg;
            return new TsDomain(newfreq, nbeg, n);
        }
        if (nfreq % freq != 0) {
            return null;
        }
        TsPeriod start = this.getStart().firstPeriod(newfreq);
        return new TsDomain(start, this.m_c * nfreq / freq);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getStart()).append(" - ").append(this.getLast());
        return builder.toString();
    }

    private static final class TSPeriodIterator
    implements Iterator<TsPeriod> {
        private final TsDomain m_dom;
        private int m_cur = 0;

        TSPeriodIterator(TsDomain domain) {
            this.m_dom = domain;
        }

        @Override
        public boolean hasNext() {
            return this.m_cur < this.m_dom.getLength();
        }

        @Override
        public TsPeriod next() {
            return this.m_dom.get(this.m_cur++);
        }
    }
}

