% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbal_tidiers.R
\name{tidy.xbal}
\alias{tidy.xbal}
\alias{glance.xbal}
\title{\code{broom::tidy()}/\code{glance()} methods for \code{balanceTest()} results}
\usage{
tidy.xbal(
  x,
  strata = dimnames(x[["results"]])[["strata"]][1],
  varnames_crosswalk = c(z = "statistic", p = "p.value"),
  format = FALSE,
  digits = max(2, getOption("digits") - 4),
  ...
)

glance.xbal(x, strata = dimnames(x[["results"]])[["strata"]][1], ...)
}
\arguments{
\item{x}{object of class \code{"xbal"}, result of \code{\link[=balanceTest]{balanceTest()}}
or \code{\link[=xBalance]{xBalance()}}}

\item{strata}{which stratification to return info about? Defaults
to last one specified in originating function call (which appears first in the xbal array).}

\item{varnames_crosswalk}{character vector of new names for xbal columns, named by the xbal column}

\item{format}{if true, apply \verb{[RItools:::original_units_var_formatter()]} to suitable sub-array en route}

\item{digits}{passed to \verb{[RItools:::original_units_var_formatter()]}}

\item{...}{Additional arguments passed to \verb{[RItools:::original_units_var_formatter()]}}
}
\value{
data frame composed of: for \verb{[RItools::tidy()]}, a column of variable labels (\code{vars}) and
additional columns of balance-related stats; for \verb{[RItools::glance()]}, scalars describing
a combined differences test, if found, and otherwise \code{NULL}.
}
\description{
Portion out the value of a \code{\link[=balanceTest]{balanceTest()}} call in a manner consistent
with assumptions of the broom package.
}
\details{
\code{\link[=tidy.xbal]{tidy.xbal()}} gives per-variable
statistics whereas \code{\link[=glance.xbal]{glance.xbal()}} extracts combined-difference related
calculations. In both cases one has to specify which stratification one wants
statistics about, as xbal objects can store info about several stratifications.
\code{\link[=tidy.xbal]{tidy.xbal()}} has a parameter \code{varnames_crosswalk} not shared with
\code{\link[=glance.xbal]{glance.xbal()}}. It should be a named character vector, the elements
of which give names of columns to be returned and the names of which correspond
to columns of xbal objects' \sQuote{results} entry.  Its ordering dictates the order
of the result. The default value translates between conventional xbal
column names and broom package conventional names.

\describe{
\item{vars}{variable name}
\item{Control}{mean of LHS variable = 0 group}
\item{Treatment}{ mean of LHS variable = 1 group}
\item{adj.diff}{T - C diff w/ direct standardization for strata if applicable}
\item{std.diff}{adj.diff/pooled.sd}
\item{pooled.sd}{pooled SD}
\item{statistic}{\code{z} column from the xbal object}
\item{p.value}{\code{p} column from the xbal object}
}
Additional parameters beyond those listed here are ignored (at this time).
}
