% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design.R
\docType{class}
\name{CovsAlignedToADesign-class}
\alias{CovsAlignedToADesign-class}
\title{CovsAlignedToADesign S4 class}
\description{
A class for representing covariate matrices after alignment within stratum,
for a (single) given stratifying factor.  There can also be a clustering variable,
assumed to be nested within the stratifying variable.
}
\details{
In contrast to DesignOptions, this class represents the combination of a single Covariates
table, realized treatment assignment and treatment assignment scheme, not multiple treatment
assignment schemes (designs). These Covariates are assumed to reflect regularization, s.t.
missings have been patched with a value and then all of the covariate values have been aligned
within each stratum.  In lieu of a NotMissing slot there will be Covariates columns, also
centered within a stratum, recording
non-missingness of the original data.

Ordinarily the StrataWeightRatio slot has an entry for each unit, representing ratio of
specified stratum weight to the product of \eqn{h_b} (the harmonic mean of \eqn{n_\{tb\}} and
\eqn{n_{cb}}, the counts of treatment and control clusters in stratum \eqn{b}) with \eqn{bar-w_b},
(the arithmetic mean of aggregated cluster weights within that stratum). It can also
be the numeric vector 1, without names, meaning the intended weight ratio is always 1.
}
\section{Slots}{

\describe{
\item{\code{Covariates}}{Numeric matrix, as in ModelMatrixPlus, except: will include NM columns; all columns presumed to have been stratum-centered (aligned)}

\item{\code{UnitWeights}}{vector of weights associated w/ rows of Covariates}

\item{\code{Z}}{Logical indicating treatment assignment}

\item{\code{StrataMatrix}}{A sparse matrix with n rows and s columns, with 1 if the unit is in that stratification}

\item{\code{StrataWeightRatio}}{For each unit, ratio of stratum weight to \eqn{h_b}; but see Details.}

\item{\code{Cluster}}{Factor indicating who's in the same cluster with who}

\item{\code{OriginalVariables}}{Look up table associating Covariates cols to terms in the calling formula, as in ModelMatrixPlus}
}}

\keyword{internal}
