% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_config.R
\name{create_config}
\alias{create_config}
\title{Creates an app config file, "config.cfg"}
\usage{
create_config(app_name, app_dir, pkgs, remotes = "none",
  repo = "http://cran.rstudio.com", error_log = "error.log",
  app_repo_url = "none", auth_user = "none", auth_pw = "none",
  user_browser = "chrome")
}
\arguments{
\item{app_name}{The name of the app being installed. It will be displayed throughout the installer's window titles, wizard pages, and dialog boxes. See \href{http://www.jrsoftware.org/ishelp/topic_setup_appname.htm}{[Setup]:AppName} for details. For continuous installations, \code{app_name} is used to check for an R package of the same name, and update it. The Continuous Installation vignette has more details.}

\item{app_dir}{Shiny app's directory, defaults to \code{getwd()}.}

\item{pkgs}{String vector of the shiny app's default repo package dependencies. See \code{\link{create_config}} for how to change the default repo.}

\item{remotes}{Character vector of GitHub repository addresses in the format \code{username/repo[/subdir][\@ref|#pull]} for GitHub package dependencies.}

\item{repo}{Default repository to install package dependencies from. This defaults to \code{repo = "http://cran.rstudio.com"}.}

\item{error_log}{Name of error logging file. Contains start up errors from \emph{run.R}.}

\item{app_repo_url}{Repository address in the format \code{"https://bitbucket.org/username/repo"} (\code{repo = app_name}). Only Bitbucket and GitHub repositories are supported.}

\item{auth_user}{Authorized username. It is recommended to create a read-only account for each app.  Support for OAuth 2 and tokens is in the works.}

\item{auth_pw}{Password to Bitbucket or GitHub.}

\item{user_browser}{Character for the default browser. Options include "chrome", "firefox", and "ie."}
}
\value{
A json file, \emph{config.cfg}, in \code{app_dir}/utils.
}
\description{
Creates an app config file, "config.cfg"
}
\seealso{
\code{\link{create_app}}.
}
\author{
Jonathan M. Hill
}
