/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Rectangle;

public class Info
implements PlugInFilter {
    private ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        String string = this.getImageInfo(this.imp, imageProcessor);
        if (string.indexOf("----") > 0) {
            this.showInfo(string, 450, 500);
        } else {
            this.showInfo(string, 300, 300);
        }
    }

    public String getImageInfo(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        Object object;
        String string;
        String string2 = null;
        if (imagePlus.getStackSize() > 1 && (string = ((ImageStack)(object = imagePlus.getStack())).getSliceLabel(imagePlus.getCurrentSlice())) != null && string.indexOf(10) > 0) {
            string2 = string;
        }
        if (string2 == null) {
            string2 = (String)imagePlus.getProperty("Info");
        }
        object = this.getInfo(imagePlus, imageProcessor);
        if (string2 != null) {
            return string2 + "\n------------------------\n" + (String)object;
        }
        return object;
    }

    String getInfo(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        Roi roi;
        double d;
        double d2;
        double d3;
        String string;
        int n;
        String string2 = new String("\n");
        string2 = string2 + "Title: " + imagePlus.getTitle() + "\n";
        Calibration calibration = imagePlus.getCalibration();
        int n2 = imagePlus.getStackSize();
        int n3 = imagePlus.getNChannels();
        int n4 = imagePlus.getNSlices();
        int n5 = imagePlus.getNFrames();
        int n6 = n = imagePlus.getBitDepth() == 32 ? 4 : 0;
        if (calibration.scaled()) {
            string = calibration.getUnit();
            String string3 = calibration.getUnits();
            string2 = string2 + "Width:  " + IJ.d2s((double)imagePlus.getWidth() * calibration.pixelWidth, 2) + " " + string3 + " (" + imagePlus.getWidth() + ")\n";
            string2 = string2 + "Height:  " + IJ.d2s((double)imagePlus.getHeight() * calibration.pixelHeight, 2) + " " + string3 + " (" + imagePlus.getHeight() + ")\n";
            if (n2 > 1) {
                string2 = string2 + "Depth:  " + IJ.d2s((double)n4 * calibration.pixelDepth, 2) + " " + string3 + " (" + n4 + ")\n";
            }
            d3 = 1.0 / calibration.pixelWidth;
            d2 = 1.0 / calibration.pixelHeight;
            int n7 = Tools.getDecimalPlaces(d3, d2);
            if (d3 == d2) {
                string2 = string2 + "Resolution:  " + IJ.d2s(d3, n7) + " pixels per " + string + "\n";
            } else {
                string2 = string2 + "X Resolution:  " + IJ.d2s(d3, n7) + " pixels per " + string + "\n";
                string2 = string2 + "Y Resolution:  " + IJ.d2s(d2, n7) + " pixels per " + string + "\n";
            }
        } else {
            string2 = string2 + "Width:  " + imagePlus.getWidth() + " pixels\n";
            string2 = string2 + "Height:  " + imagePlus.getHeight() + " pixels\n";
            if (n2 > 1) {
                string2 = string2 + "Depth:  " + n4 + " pixels\n";
            }
        }
        string2 = string2 + "ID: " + imagePlus.getID() + "\n";
        string = n2 > 1 || calibration.zOrigin != 0.0 ? "," + this.d2s(calibration.zOrigin) : "";
        string2 = string2 + "Coordinate origin:  " + this.d2s(calibration.xOrigin) + "," + this.d2s(calibration.yOrigin) + string + "\n";
        int n8 = imagePlus.getType();
        switch (n8) {
            case 0: {
                string2 = string2 + "Bits per pixel: 8 ";
                String string4 = "LUT";
                string4 = imagePlus.getProcessor().isColorLut() ? "color " + string4 : "grayscale " + string4;
                if (imagePlus.isInvertedLut()) {
                    string4 = "inverting " + string4;
                }
                string2 = string2 + "(" + string4 + ")\n";
                string2 = string2 + "Display range: " + (int)imageProcessor.getMin() + "-" + (int)imageProcessor.getMax() + "\n";
                break;
            }
            case 1: 
            case 2: {
                if (n8 == 1) {
                    String string5 = calibration.isSigned16Bit() ? "signed" : "unsigned";
                    string2 = string2 + "Bits per pixel: 16 (" + string5 + ")\n";
                } else {
                    string2 = string2 + "Bits per pixel: 32 (float)\n";
                }
                string2 = string2 + "Display range: ";
                double d4 = imageProcessor.getMin();
                double d5 = imageProcessor.getMax();
                if (calibration.calibrated()) {
                    d4 = calibration.getCValue((int)d4);
                    d5 = calibration.getCValue((int)d5);
                }
                string2 = string2 + IJ.d2s(d4, n) + " - " + IJ.d2s(d5, n) + "\n";
                break;
            }
            case 3: {
                string2 = string2 + "Bits per pixel: 8 (color LUT)\n";
                break;
            }
            case 4: {
                string2 = string2 + "Bits per pixel: 32 (RGB)\n";
            }
        }
        d3 = calibration.frameInterval;
        d2 = calibration.fps;
        if (n2 > 1) {
            String string6;
            ImageStack imageStack = imagePlus.getStack();
            int n9 = imagePlus.getCurrentSlice();
            String string7 = n9 + "/" + n2;
            String string8 = imageStack.getShortSliceLabel(n9);
            string8 = string8 != null && string8.length() > 0 ? " (" + string8 + ")" : "";
            if (d3 > 0.0 || d2 != 0.0) {
                string2 = string2 + "Frame: " + string7 + string8 + "\n";
                if (d2 != 0.0) {
                    string6 = Math.abs(d2 - (double)Math.round(d2)) < 1.0E-5 ? IJ.d2s(d2, 0) : IJ.d2s(d2, 5);
                    string2 = string2 + "Frame rate: " + string6 + " fps\n";
                }
                if (d3 != 0.0) {
                    string2 = string2 + "Frame interval: " + ((double)((int)d3) == d3 ? IJ.d2s(d3, 0) : IJ.d2s(d3, 5)) + " " + calibration.getTimeUnit() + "\n";
                }
            } else {
                string2 = string2 + "Image: " + string7 + string8 + "\n";
            }
            if (imagePlus.isHyperStack()) {
                if (n3 > 1) {
                    string2 = string2 + "  Channel: " + imagePlus.getChannel() + "/" + n3 + "\n";
                }
                if (n4 > 1) {
                    string2 = string2 + "  Slice: " + imagePlus.getSlice() + "/" + n4 + "\n";
                }
                if (n5 > 1) {
                    string2 = string2 + "  Frame: " + imagePlus.getFrame() + "/" + n5 + "\n";
                }
            }
            if (imagePlus.isComposite()) {
                if (!imagePlus.isHyperStack() && n3 > 1) {
                    string2 = string2 + "  Channels: " + n3 + "\n";
                }
                string6 = ((CompositeImage)imagePlus).getModeAsString();
                string2 = string2 + "  Composite mode: \"" + string6 + "\"\n";
            }
        }
        if (imageProcessor.getMinThreshold() == -808080.0) {
            string2 = string2 + "No Threshold\n";
        } else {
            double d6 = imageProcessor.getMinThreshold();
            double d7 = imageProcessor.getMaxThreshold();
            int n10 = n;
            if (calibration.calibrated()) {
                d6 = calibration.getCValue((int)d6);
                d7 = calibration.getCValue((int)d7);
                n10 = calibration.isSigned16Bit() ? 0 : 4;
            }
            string2 = string2 + "Threshold: " + IJ.d2s(d6, n10) + "-" + IJ.d2s(d7, n10) + "\n";
        }
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        double d8 = d = imageCanvas != null ? imageCanvas.getMagnification() : 1.0;
        if (d != 1.0) {
            string2 = string2 + "Magnification: " + d + "\n";
        }
        if (calibration.calibrated()) {
            string2 = string2 + " \n";
            int n11 = calibration.getFunction();
            string2 = string2 + "Calibration Function: ";
            string2 = n11 == 21 ? string2 + "Uncalibrated OD\n" : (n11 == 22 ? string2 + "Custom lookup table\n" : string2 + CurveFitter.fList[n11] + "\n");
            double[] dArray = calibration.getCoefficients();
            if (dArray != null) {
                string2 = string2 + "  a: " + IJ.d2s(dArray[0], 6) + "\n";
                string2 = string2 + "  b: " + IJ.d2s(dArray[1], 6) + "\n";
                if (dArray.length >= 3) {
                    string2 = string2 + "  c: " + IJ.d2s(dArray[2], 6) + "\n";
                }
                if (dArray.length >= 4) {
                    string2 = string2 + "  c: " + IJ.d2s(dArray[3], 6) + "\n";
                }
                if (dArray.length >= 5) {
                    string2 = string2 + "  c: " + IJ.d2s(dArray[4], 6) + "\n";
                }
            }
            string2 = string2 + "  Unit: \"" + calibration.getValueUnit() + "\"\n";
        } else {
            string2 = string2 + "Uncalibrated\n";
        }
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        if (fileInfo != null) {
            if (fileInfo.url != null && !fileInfo.url.equals("")) {
                string2 = string2 + "URL: " + fileInfo.url + "\n";
            } else if (fileInfo.directory != null && fileInfo.fileName != null) {
                string2 = string2 + "Path: " + fileInfo.directory + fileInfo.fileName + "\n";
            }
        }
        if ((roi = imagePlus.getRoi()) == null) {
            if (calibration.calibrated()) {
                string2 = string2 + " \n";
            }
            string2 = string2 + "No Selection\n";
        } else {
            String string9;
            Object object;
            string2 = string2 + " \n";
            string2 = string2 + roi.getTypeAsString() + " Selection";
            String string10 = null;
            if (roi instanceof PointRoi) {
                int n12 = ((PolygonRoi)roi).getNCoordinates();
                object = n12 > 1 ? "s)" : ")";
                string10 = " (" + n12 + " point" + (String)object;
            }
            if ((string9 = roi.getName()) != null) {
                string2 = string2 + " (\"" + string9 + "\")";
                if (string10 != null) {
                    string2 = string2 + "\n " + string10;
                }
            } else if (string10 != null) {
                string2 = string2 + string10;
            }
            string2 = string2 + "\n";
            object = roi.getBounds();
            if (roi instanceof Line) {
                Line line = (Line)roi;
                string2 = string2 + "  X1: " + IJ.d2s(line.x1d * calibration.pixelWidth) + "\n";
                string2 = string2 + "  Y1: " + IJ.d2s(this.yy(line.y1d, imagePlus) * calibration.pixelHeight) + "\n";
                string2 = string2 + "  X2: " + IJ.d2s(line.x2d * calibration.pixelWidth) + "\n";
                string2 = string2 + "  Y2: " + IJ.d2s(this.yy(line.y2d, imagePlus) * calibration.pixelHeight) + "\n";
            } else if (calibration.scaled()) {
                string2 = string2 + "  X: " + IJ.d2s((double)((Rectangle)object).x * calibration.pixelWidth) + " (" + ((Rectangle)object).x + ")\n";
                string2 = string2 + "  Y: " + IJ.d2s((double)this.yy(((Rectangle)object).y, imagePlus) * calibration.pixelHeight) + " (" + ((Rectangle)object).y + ")\n";
                string2 = string2 + "  Width: " + IJ.d2s((double)((Rectangle)object).width * calibration.pixelWidth) + " (" + ((Rectangle)object).width + ")\n";
                string2 = string2 + "  Height: " + IJ.d2s((double)((Rectangle)object).height * calibration.pixelHeight) + " (" + ((Rectangle)object).height + ")\n";
            } else {
                string2 = string2 + "  X: " + ((Rectangle)object).x + "\n";
                string2 = string2 + "  Y: " + this.yy(((Rectangle)object).y, imagePlus) + "\n";
                string2 = string2 + "  Width: " + ((Rectangle)object).width + "\n";
                string2 = string2 + "  Height: " + ((Rectangle)object).height + "\n";
            }
        }
        return string2;
    }

    String d2s(double d) {
        return d == (double)((int)d) ? Integer.toString((int)d) : IJ.d2s(d);
    }

    int yy(int n, ImagePlus imagePlus) {
        return Analyzer.updateY(n, imagePlus.getHeight());
    }

    double yy(double d, ImagePlus imagePlus) {
        return Analyzer.updateY(d, imagePlus.getHeight());
    }

    void showInfo(String string, int n, int n2) {
        new TextWindow("Info for " + this.imp.getTitle(), string, n, n2);
    }
}

