/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Undo;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiProperties;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

public class OverlayCommands
implements PlugIn {
    private static boolean createImageRoi;

    public void run(String string) {
        if (string.equals("add")) {
            this.addSelection();
        } else if (string.equals("image")) {
            this.addImage();
        } else if (string.equals("flatten")) {
            this.flatten();
        } else if (string.equals("hide")) {
            this.hide();
        } else if (string.equals("show")) {
            this.show();
        } else if (string.equals("remove")) {
            this.remove();
        } else if (string.equals("from")) {
            this.fromRoiManager();
        } else if (string.equals("to")) {
            this.toRoiManager();
        }
    }

    void addSelection() {
        boolean bl;
        Object object;
        boolean bl2;
        boolean bl3;
        ImagePlus imagePlus = IJ.getImage();
        String string = Macro.getOptions();
        if (string != null && IJ.macroRunning() && string.indexOf("remove") != -1) {
            imagePlus.setOverlay(null);
            return;
        }
        Roi roi = imagePlus.getRoi();
        if (roi == null && imagePlus.getOverlay() != null) {
            GenericDialog genericDialog = new GenericDialog("No Selection");
            genericDialog.addMessage("\"Overlay>Add\" requires a selection.");
            genericDialog.setInsets(15, 40, 0);
            genericDialog.addCheckbox("Remove existing overlay", false);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return;
            }
            if (genericDialog.getNextBoolean()) {
                imagePlus.setOverlay(null);
            }
            return;
        }
        if (roi == null) {
            IJ.error("This command requires a selection.");
            return;
        }
        roi = (Roi)roi.clone();
        Overlay overlay = imagePlus.getOverlay();
        if (overlay != null && overlay.size() > 0 && !roi.isDrawingTool()) {
            Roi roi2 = overlay.get(overlay.size() - 1);
            if (roi.getStroke() == null) {
                roi.setStrokeWidth(roi2.getStrokeWidth());
            }
            if (roi.getStrokeColor() == null || Line.getWidth() > 1 && roi2.getStrokeColor() != null) {
                roi.setStrokeColor(roi2.getStrokeColor());
            }
            if (roi.getFillColor() == null) {
                roi.setFillColor(roi2.getFillColor());
            }
        }
        int n = Line.getWidth();
        Rectangle rectangle = roi.getBounds();
        boolean bl4 = bl3 = (double)n > (double)Math.max(rectangle.width, rectangle.height) / 3.0;
        if (roi.getStroke() == null && n > 1 && !bl3) {
            roi.setStrokeWidth(Line.getWidth());
        }
        if (roi.getStrokeColor() == null) {
            roi.setStrokeColor(Toolbar.getForegroundColor());
        }
        boolean bl5 = bl2 = roi instanceof PointRoi && ((PolygonRoi)roi).getNCoordinates() > 1;
        if (bl2) {
            roi.setStrokeColor(Color.red);
        }
        if (!(IJ.altKeyDown() || roi instanceof Arrow || ((RoiProperties)(object = new RoiProperties("Add to Overlay", roi))).showDialog())) {
            return;
        }
        object = roi.getName();
        boolean bl6 = bl = object != null && ((String)object).equals("new-overlay");
        if (overlay == null || bl) {
            overlay = new Overlay();
        }
        overlay.add(roi);
        imagePlus.setOverlay(overlay);
        if (bl2 || roi instanceof ImageRoi || roi instanceof Arrow) {
            imagePlus.killRoi();
        }
        Undo.setup(7, imagePlus);
    }

    void addImage() {
        Object object;
        ImageObserver imageObserver;
        int n;
        ImagePlus imagePlus = IJ.getImage();
        int[] nArray = WindowManager.getIDList();
        if (nArray == null || nArray.length < 2) {
            IJ.error("Add Image...", "The command requires at least two open images.");
            return;
        }
        String[] stringArray = new String[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            ImagePlus imagePlus2 = WindowManager.getImage(nArray[n]);
            stringArray[n] = imagePlus2 != null ? imagePlus2.getTitle() : "";
        }
        n = 0;
        int n2 = 0;
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi.isArea()) {
            Rectangle rectangle = roi.getBounds();
            n = rectangle.x;
            n2 = rectangle.y;
        }
        int n3 = 0;
        if (nArray.length == 2) {
            imageObserver = WindowManager.getImage(nArray[0]);
            ImagePlus imagePlus3 = WindowManager.getImage(nArray[1]);
            if (imagePlus3.getWidth() < ((ImagePlus)imageObserver).getWidth() && imagePlus3.getHeight() < ((ImagePlus)imageObserver).getHeight()) {
                n3 = 1;
            }
        } else if (imagePlus.getID() == nArray[0]) {
            n3 = 1;
        }
        imageObserver = new GenericDialog("Add Image...");
        ((GenericDialog)imageObserver).addChoice("Image to add:", stringArray, stringArray[n3]);
        ((GenericDialog)imageObserver).addNumericField("X location:", n, 0);
        ((GenericDialog)imageObserver).addNumericField("Y location:", n2, 0);
        ((GenericDialog)imageObserver).addNumericField("Opacity (0-100%):", 100.0, 0);
        ((GenericDialog)imageObserver).addCheckbox("Create image selection", createImageRoi);
        ((GenericDialog)imageObserver).showDialog();
        if (((GenericDialog)imageObserver).wasCanceled()) {
            return;
        }
        n3 = ((GenericDialog)imageObserver).getNextChoiceIndex();
        n = (int)((GenericDialog)imageObserver).getNextNumber();
        n2 = (int)((GenericDialog)imageObserver).getNextNumber();
        double d = ((GenericDialog)imageObserver).getNextNumber() / 100.0;
        createImageRoi = ((GenericDialog)imageObserver).getNextBoolean();
        ImagePlus imagePlus4 = WindowManager.getImage(nArray[n3]);
        if (nArray.length == 2) {
            object = WindowManager.getImage(nArray[0]);
            ImagePlus imagePlus5 = WindowManager.getImage(nArray[1]);
            if (imagePlus5.getWidth() < ((ImagePlus)object).getWidth() && imagePlus5.getHeight() < ((ImagePlus)object).getHeight()) {
                imagePlus = object;
                imagePlus4 = imagePlus5;
            }
        }
        if (imagePlus4 == imagePlus) {
            IJ.error("Add Image...", "Image to be added cannot be the same as\n\"" + imagePlus.getTitle() + "\".");
            return;
        }
        if (imagePlus4.getWidth() > imagePlus.getWidth() && imagePlus4.getHeight() > imagePlus.getHeight()) {
            IJ.error("Add Image...", "Image to be added cannnot be larger than\n\"" + imagePlus.getTitle() + "\".");
            return;
        }
        if (createImageRoi && n == 0 && n2 == 0) {
            n = imagePlus.getWidth() / 2 - imagePlus4.getWidth() / 2;
            n2 = imagePlus.getHeight() / 2 - imagePlus4.getHeight() / 2;
        }
        roi = new ImageRoi(n, n2, imagePlus4.getProcessor());
        roi.setName(imagePlus4.getShortTitle());
        if (d != 1.0) {
            ((ImageRoi)roi).setOpacity(d);
        }
        if (createImageRoi) {
            imagePlus.setRoi(roi);
        } else {
            object = imagePlus.getOverlay();
            if (object == null) {
                object = new Overlay();
            }
            ((Overlay)object).add(roi);
            imagePlus.setOverlay((Overlay)object);
            Undo.setup(7, imagePlus);
        }
    }

    void hide() {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.setHideOverlay(true);
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager != null) {
            roiManager.runCommand("show none");
        }
    }

    void show() {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.setHideOverlay(false);
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager != null) {
            roiManager.runCommand("show all");
        }
    }

    void remove() {
        RoiManager roiManager;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            imagePlus.setOverlay(null);
        }
        if ((roiManager = RoiManager.getInstance()) != null) {
            roiManager.runCommand("show none");
        }
    }

    void flatten() {
        ImagePlus imagePlus = IJ.getImage();
        ImagePlus imagePlus2 = imagePlus.flatten();
        imagePlus2.setTitle(WindowManager.getUniqueName(imagePlus.getTitle()));
        imagePlus2.show();
    }

    void fromRoiManager() {
        ImagePlus imagePlus = IJ.getImage();
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager == null) {
            IJ.error("ROI Manager is not open");
            return;
        }
        Roi[] roiArray = roiManager.getRoisAsArray();
        if (roiArray.length == 0) {
            IJ.error("ROI Manager is empty");
            return;
        }
        Overlay overlay = new Overlay();
        for (int i = 0; i < roiArray.length; ++i) {
            overlay.add((Roi)roiArray[i].clone());
        }
        imagePlus.setOverlay(overlay);
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas != null) {
            imageCanvas.setShowAllROIs(false);
        }
        roiManager.setEditMode(imagePlus, false);
        imagePlus.killRoi();
    }

    void toRoiManager() {
        ImagePlus imagePlus = IJ.getImage();
        Overlay overlay = imagePlus.getOverlay();
        if (overlay == null) {
            IJ.error("Overlay required");
            return;
        }
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager == null) {
            if (Macro.getOptions() != null && Interpreter.isBatchMode()) {
                roiManager = Interpreter.getBatchModeRoiManager();
            }
            if (roiManager == null) {
                Frame frame = WindowManager.getFrame("ROI Manager");
                if (frame == null) {
                    IJ.run("ROI Manager...");
                }
                if ((frame = WindowManager.getFrame("ROI Manager")) == null || !(frame instanceof RoiManager)) {
                    return;
                }
                roiManager = (RoiManager)frame;
            }
        }
        roiManager.runCommand("reset");
        for (int i = 0; i < overlay.size(); ++i) {
            roiManager.add(imagePlus, overlay.get(i), i);
        }
        roiManager.setEditMode(imagePlus, true);
        if (roiManager.getCount() == overlay.size()) {
            imagePlus.setOverlay(null);
        }
    }
}

