/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.BitBuffer;
import ij.io.ByteVector;
import ij.io.FileInfo;
import ij.io.RandomAccessStream;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageReader {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private FileInfo fi;
    private int width;
    private int height;
    private long skipCount;
    private int bytesPerPixel;
    private int bufferSize;
    private int byteCount;
    private int nPixels;
    private boolean showProgressBar = true;
    private int eofErrorCount;
    private long startTime;
    public double min;
    public double max;

    public ImageReader(FileInfo fileInfo) {
        this.fi = fileInfo;
        this.width = fileInfo.width;
        this.height = fileInfo.height;
        this.skipCount = fileInfo.getOffset();
    }

    void eofError() {
        ++this.eofErrorCount;
    }

    byte[] read8bitImage(InputStream inputStream) throws IOException {
        if (this.fi.compression > 1) {
            return this.readCompressed8bitImage(inputStream);
        }
        byte[] byArray = new byte[this.nPixels];
        int n = 0;
        while (n < this.byteCount) {
            int n2 = n + this.bufferSize > this.byteCount ? this.byteCount - n : this.bufferSize;
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                this.eofError();
                break;
            }
            this.showProgress(n += n3, this.byteCount);
        }
        return byArray;
    }

    byte[] readCompressed8bitImage(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.nPixels];
        int n = 0;
        byte by = 0;
        for (int i = 0; i < this.fi.stripOffsets.length; ++i) {
            int n2;
            long l;
            if (inputStream instanceof RandomAccessStream) {
                ((RandomAccessStream)inputStream).seek(this.fi.stripOffsets[i]);
            } else if (i > 0 && (l = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                inputStream.skip(l);
            }
            byte[] byArray2 = new byte[this.fi.stripLengths[i]];
            int n3 = 0;
            for (int j = byArray2.length; j > 0; j -= n2) {
                n2 = inputStream.read(byArray2, n3, j);
                if (n2 == -1) {
                    this.eofError();
                    break;
                }
                n3 += n2;
            }
            byArray2 = this.uncompress(byArray2, this.nPixels - n);
            n2 = byArray2.length;
            n2 -= n2 % this.fi.width;
            if (this.fi.compression == 3) {
                for (int j = 0; j < n2; ++j) {
                    int n4 = j;
                    byArray2[n4] = (byte)(byArray2[n4] + by);
                    by = j % this.fi.width == this.fi.width - 1 ? (byte)0 : byArray2[j];
                }
            }
            if (n + n2 > byArray.length) {
                n2 = byArray.length - n;
            }
            System.arraycopy(byArray2, 0, byArray, n, n2);
            n += n2;
            this.showProgress(i + 1, this.fi.stripOffsets.length);
        }
        return byArray;
    }

    short[] read16bitImage(InputStream inputStream) throws IOException {
        if (this.fi.compression > 1 || this.fi.stripOffsets != null && this.fi.stripOffsets.length > 1) {
            return this.readCompressed16bitImage(inputStream);
        }
        byte[] byArray = new byte[this.bufferSize];
        short[] sArray = new short[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            int n3;
            int n4;
            int n5;
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            for (int i = 0; i < this.bufferSize; i += n5) {
                n5 = inputStream.read(byArray, i, this.bufferSize - i);
                if (n5 != -1) continue;
                if (i > 0) {
                    for (n4 = i; n4 < this.bufferSize; ++n4) {
                        byArray[n4] = 0;
                    }
                }
                n = this.byteCount;
                this.eofError();
                break;
            }
            this.showProgress(n += this.bufferSize, this.byteCount);
            int n6 = this.bufferSize / this.bytesPerPixel;
            if (this.fi.intelByteOrder) {
                if (this.fi.fileType == 1) {
                    n4 = n2;
                    n3 = 0;
                    while (n4 < n2 + n6) {
                        sArray[n4] = (short)(((byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF) + 32768);
                        ++n4;
                        n3 += 2;
                    }
                } else {
                    n4 = n2;
                    n3 = 0;
                    while (n4 < n2 + n6) {
                        sArray[n4] = (short)((byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF);
                        ++n4;
                        n3 += 2;
                    }
                }
            } else if (this.fi.fileType == 1) {
                n4 = n2;
                n3 = 0;
                while (n4 < n2 + n6) {
                    sArray[n4] = (short)(((byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF) + 32768);
                    ++n4;
                    n3 += 2;
                }
            } else {
                n4 = n2;
                n3 = 0;
                while (n4 < n2 + n6) {
                    sArray[n4] = (short)((byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF);
                    ++n4;
                    n3 += 2;
                }
            }
            n2 += n6;
        }
        return sArray;
    }

    short[] readCompressed16bitImage(InputStream inputStream) throws IOException {
        int n;
        inputStream = new DataInputStream(inputStream);
        short[] sArray = new short[this.nPixels];
        int n2 = 0;
        short s = 0;
        for (n = 0; n < this.fi.stripOffsets.length; ++n) {
            int n3;
            int n4;
            int n5;
            int n6;
            long l;
            if (inputStream instanceof RandomAccessStream) {
                ((RandomAccessStream)inputStream).seek(this.fi.stripOffsets[n]);
            } else if (n > 0 && (l = ((long)this.fi.stripOffsets[n] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[n - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[n - 1]) > 0L) {
                inputStream.skip(l);
            }
            byte[] byArray = new byte[this.fi.stripLengths[n]];
            int n7 = 0;
            for (int i = byArray.length; i > 0; i -= n6) {
                n6 = inputStream.read(byArray, n7, i);
                if (n6 == -1) {
                    this.eofError();
                    break;
                }
                n7 += n6;
            }
            byArray = this.uncompress(byArray);
            n6 = byArray.length / this.bytesPerPixel;
            if ((n5 = n2 + (n6 -= n6 % this.fi.width)) > this.nPixels) {
                n5 = this.nPixels;
            }
            if (this.fi.intelByteOrder) {
                n4 = n2;
                n3 = 0;
                while (n4 < n5) {
                    sArray[n4] = (short)((byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF);
                    ++n4;
                    n3 += 2;
                }
            } else {
                n4 = n2;
                n3 = 0;
                while (n4 < n5) {
                    sArray[n4] = (short)((byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF);
                    ++n4;
                    n3 += 2;
                }
            }
            if (this.fi.compression == 3) {
                for (n4 = n2; n4 < n5; ++n4) {
                    int n8 = n4;
                    sArray[n8] = (short)(sArray[n8] + s);
                    s = n4 % this.fi.width == this.fi.width - 1 ? (short)0 : sArray[n4];
                }
            }
            n2 += n6;
            this.showProgress(n + 1, this.fi.stripOffsets.length);
        }
        if (this.fi.fileType == 1) {
            for (n = 0; n < this.nPixels; ++n) {
                sArray[n] = (short)(sArray[n] + 32768);
            }
        }
        return sArray;
    }

    float[] read32bitImage(InputStream inputStream) throws IOException {
        if (this.fi.compression > 1) {
            return this.readCompressed32bitImage(inputStream);
        }
        byte[] byArray = new byte[this.bufferSize];
        float[] fArray = new float[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            for (int i = 0; i < this.bufferSize; i += n6) {
                n6 = inputStream.read(byArray, i, this.bufferSize - i);
                if (n6 != -1) continue;
                if (i > 0) {
                    for (n5 = i; n5 < this.bufferSize; ++n5) {
                        byArray[n5] = 0;
                    }
                }
                n = this.byteCount;
                this.eofError();
                break;
            }
            this.showProgress(n += this.bufferSize, this.byteCount);
            int n7 = this.bufferSize / this.bytesPerPixel;
            n5 = n2 + n7;
            if (n5 > this.nPixels) {
                n5 = this.nPixels;
            }
            int n8 = 0;
            if (this.fi.intelByteOrder) {
                for (n4 = n2; n4 < n5; ++n4) {
                    n3 = (byArray[n8 + 3] & 0xFF) << 24 | (byArray[n8 + 2] & 0xFF) << 16 | (byArray[n8 + 1] & 0xFF) << 8 | byArray[n8] & 0xFF;
                    fArray[n4] = this.fi.fileType == 4 ? Float.intBitsToFloat(n3) : (this.fi.fileType == 11 ? (float)((long)n3 & 0xFFFFFFFFL) : (float)n3);
                    n8 += 4;
                }
            } else {
                for (n4 = n2; n4 < n5; ++n4) {
                    n3 = (byArray[n8] & 0xFF) << 24 | (byArray[n8 + 1] & 0xFF) << 16 | (byArray[n8 + 2] & 0xFF) << 8 | byArray[n8 + 3] & 0xFF;
                    fArray[n4] = this.fi.fileType == 4 ? Float.intBitsToFloat(n3) : (this.fi.fileType == 11 ? (float)((long)n3 & 0xFFFFFFFFL) : (float)n3);
                    n8 += 4;
                }
            }
            n2 += n7;
        }
        return fArray;
    }

    float[] readCompressed32bitImage(InputStream inputStream) throws IOException {
        inputStream = new DataInputStream(inputStream);
        float[] fArray = new float[this.nPixels];
        int n = 0;
        float f = 0.0f;
        for (int i = 0; i < this.fi.stripOffsets.length; ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            long l;
            if (inputStream instanceof RandomAccessStream) {
                ((RandomAccessStream)inputStream).seek(this.fi.stripOffsets[i]);
            } else if (i > 0 && (l = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                inputStream.skip(l);
            }
            byte[] byArray = new byte[this.fi.stripLengths[i]];
            int n7 = 0;
            for (int j = byArray.length; j > 0; j -= n6) {
                n6 = inputStream.read(byArray, n7, j);
                if (n6 == -1) {
                    this.eofError();
                    break;
                }
                n7 += n6;
            }
            byArray = this.uncompress(byArray);
            n6 = byArray.length / this.bytesPerPixel;
            if ((n5 = n + (n6 -= n6 % this.fi.width)) > this.nPixels) {
                n5 = this.nPixels;
            }
            if (this.fi.intelByteOrder) {
                n4 = n;
                n3 = 0;
                while (n4 < n5) {
                    n2 = (byArray[n3 + 3] & 0xFF) << 24 | (byArray[n3 + 2] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3] & 0xFF;
                    fArray[n4] = Float.intBitsToFloat(n2);
                    ++n4;
                    n3 += 4;
                }
            } else {
                n4 = n;
                n3 = 0;
                while (n4 < n5) {
                    n2 = (byArray[n3] & 0xFF) << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
                    fArray[n4] = Float.intBitsToFloat(n2);
                    ++n4;
                    n3 += 4;
                }
            }
            if (this.fi.compression == 3) {
                for (n4 = n; n4 < n5; ++n4) {
                    int n8 = n4;
                    fArray[n8] = fArray[n8] + f;
                    f = n4 % this.fi.width == this.fi.width - 1 ? 0.0f : fArray[n4];
                }
            }
            n += n6;
            this.showProgress(i + 1, this.fi.stripOffsets.length);
        }
        return fArray;
    }

    float[] read64bitImage(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.bufferSize];
        float[] fArray = new float[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            int n3;
            int n4;
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            for (int i = 0; i < this.bufferSize; i += n4) {
                n4 = inputStream.read(byArray, i, this.bufferSize - i);
                if (n4 != -1) continue;
                if (i > 0) {
                    for (n3 = i; n3 < this.bufferSize; ++n3) {
                        byArray[n3] = 0;
                    }
                }
                n = this.byteCount;
                this.eofError();
                break;
            }
            this.showProgress(n += this.bufferSize, this.byteCount);
            int n5 = this.bufferSize / this.bytesPerPixel;
            n3 = 0;
            for (int i = n2; i < n2 + n5; ++i) {
                long l = byArray[n3 + 7] & 0xFF;
                long l2 = byArray[n3 + 6] & 0xFF;
                long l3 = byArray[n3 + 5] & 0xFF;
                long l4 = byArray[n3 + 4] & 0xFF;
                long l5 = byArray[n3 + 3] & 0xFF;
                long l6 = byArray[n3 + 2] & 0xFF;
                long l7 = byArray[n3 + 1] & 0xFF;
                long l8 = byArray[n3] & 0xFF;
                long l9 = this.fi.intelByteOrder ? l << 56 | l2 << 48 | l3 << 40 | l4 << 32 | l5 << 24 | l6 << 16 | l7 << 8 | l8 : l8 << 56 | l7 << 48 | l6 << 40 | l5 << 32 | l4 << 24 | l3 << 16 | l2 << 8 | l;
                fArray[i] = (float)Double.longBitsToDouble(l9);
                n3 += 8;
            }
            n2 += n5;
        }
        return fArray;
    }

    int[] readChunkyRGB(InputStream inputStream) throws IOException {
        if (this.fi.compression == 4) {
            return this.readJPEG(inputStream);
        }
        if (this.fi.compression > 1) {
            return this.readCompressedChunkyRGB(inputStream);
        }
        this.bufferSize = 24 * this.width;
        byte[] byArray = new byte[this.bufferSize];
        int[] nArray = new int[this.nPixels];
        int n = 0;
        int n2 = 0;
        while (n < this.byteCount) {
            int n3;
            int n4;
            if (n + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - n;
            }
            for (int i = 0; i < this.bufferSize; i += n4) {
                n4 = inputStream.read(byArray, i, this.bufferSize - i);
                if (n4 != -1) continue;
                if (i > 0) {
                    for (n3 = i; n3 < this.bufferSize; ++n3) {
                        byArray[n3] = 0;
                    }
                }
                n = this.byteCount;
                this.eofError();
                break;
            }
            this.showProgress(n += this.bufferSize, this.byteCount);
            int n5 = this.bufferSize / this.bytesPerPixel;
            n3 = this.fi.fileType == 10 ? 1 : 0;
            int n6 = 0;
            for (int i = n2; i < n2 + n5; ++i) {
                int n7;
                int n8;
                int n9;
                if (this.bytesPerPixel == 4) {
                    if (this.fi.fileType == 15) {
                        n9 = byArray[n6++] & 0xFF;
                        int n10 = ++n6;
                        n8 = byArray[n10] & 0xFF;
                        int n11 = ++n6;
                        ++n6;
                        n7 = byArray[n11] & 0xFF;
                    } else if (this.fi.fileType == 18) {
                        n9 = byArray[n6++] & 0xFF;
                        n7 = byArray[n6++] & 0xFF;
                        n8 = byArray[n6++] & 0xFF;
                        ++n6;
                    } else {
                        n8 = byArray[n6++] & 0xFF;
                        n7 = byArray[n6++] & 0xFF;
                        n9 = byArray[n6++] & 0xFF;
                        ++n6;
                    }
                } else {
                    n8 = byArray[n6++] & 0xFF;
                    n7 = byArray[n6++] & 0xFF;
                    n9 = byArray[n6++] & 0xFF;
                }
                nArray[i] = n3 != 0 ? 0xFF000000 | n9 << 16 | n7 << 8 | n8 : 0xFF000000 | n8 << 16 | n7 << 8 | n9;
            }
            n2 += n5;
        }
        return nArray;
    }

    int[] readCompressedChunkyRGB(InputStream inputStream) throws IOException {
        int[] nArray = new int[this.nPixels];
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl4 = this.fi.fileType == 10;
        boolean bl5 = this.fi.compression == 3;
        for (int i = 0; i < this.fi.stripOffsets.length; ++i) {
            int n5;
            int n6;
            long l;
            if (i > 0 && (l = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                inputStream.skip(l);
            }
            byte[] byArray = new byte[this.fi.stripLengths[i]];
            int n7 = 0;
            for (int j = byArray.length; j > 0; j -= n6) {
                n6 = inputStream.read(byArray, n7, j);
                if (n6 == -1) {
                    this.eofError();
                    break;
                }
                n7 += n6;
            }
            byArray = this.uncompress(byArray);
            if (bl5) {
                for (n6 = 0; n6 < byArray.length; ++n6) {
                    if (n6 / this.bytesPerPixel % this.fi.width == 0) continue;
                    int n8 = n6;
                    byArray[n8] = (byte)(byArray[n8] + byArray[n6 - this.bytesPerPixel]);
                }
            }
            n6 = 0;
            int n9 = byArray.length / this.bytesPerPixel;
            if ((n5 = n + (n9 -= n9 % this.fi.width)) > this.nPixels) {
                n5 = this.nPixels;
            }
            for (int j = n; j < n5; ++j) {
                if (this.bytesPerPixel == 4) {
                    n2 = byArray[n6++] & 0xFF;
                    n3 = byArray[n6++] & 0xFF;
                    n4 = byArray[n6++] & 0xFF;
                    ++n6;
                } else {
                    n2 = byArray[n6++] & 0xFF;
                    n3 = byArray[n6++] & 0xFF;
                    n4 = byArray[n6++] & 0xFF;
                }
                nArray[j] = bl4 ? 0xFF000000 | n4 << 16 | n3 << 8 | n2 : 0xFF000000 | n2 << 16 | n3 << 8 | n4;
            }
            n += n9;
            this.showProgress(i + 1, this.fi.stripOffsets.length);
        }
        return nArray;
    }

    int[] readJPEG(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        ColorProcessor colorProcessor = new ColorProcessor(bufferedImage);
        return (int[])((ImageProcessor)colorProcessor).getPixels();
    }

    int[] readPlanarRGB(InputStream inputStream) throws IOException {
        int n;
        if (this.fi.compression > 1) {
            return this.readCompressedPlanarRGBImage(inputStream);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = this.nPixels;
        byte[] byArray = new byte[n2];
        int[] nArray = new int[this.nPixels];
        this.startTime = 0L;
        this.showProgress(10, 100);
        dataInputStream.readFully(byArray);
        for (n = 0; n < n2; ++n) {
            int n3 = byArray[n] & 0xFF;
            nArray[n] = 0xFF000000 | n3 << 16;
        }
        this.showProgress(40, 100);
        dataInputStream.readFully(byArray);
        n = 0;
        while (n < n2) {
            int n4 = byArray[n] & 0xFF;
            int n5 = n++;
            nArray[n5] = nArray[n5] | n4 << 8;
        }
        this.showProgress(70, 100);
        dataInputStream.readFully(byArray);
        n = 0;
        while (n < n2) {
            int n6 = byArray[n] & 0xFF;
            int n7 = n++;
            nArray[n7] = nArray[n7] | n6;
        }
        this.showProgress(90, 100);
        return nArray;
    }

    int[] readCompressedPlanarRGBImage(InputStream inputStream) throws IOException {
        int n;
        int[] nArray = new int[this.nPixels];
        this.nPixels *= 3;
        byte[] byArray = this.readCompressed8bitImage(inputStream);
        this.nPixels /= 3;
        for (n = 0; n < this.nPixels; ++n) {
            int n2 = byArray[n] & 0xFF;
            nArray[n] = 0xFF000000 | n2 << 16;
        }
        n = 0;
        while (n < this.nPixels) {
            int n3 = byArray[this.nPixels + n] & 0xFF;
            int n4 = n++;
            nArray[n4] = nArray[n4] | n3 << 8;
        }
        n = 0;
        while (n < this.nPixels) {
            int n5 = byArray[this.nPixels * 2 + n] & 0xFF;
            int n6 = n++;
            nArray[n6] = nArray[n6] | n5;
        }
        return nArray;
    }

    private void showProgress(int n, int n2) {
        if (this.showProgressBar && System.currentTimeMillis() - this.startTime > 500L) {
            IJ.showProgress(n, n2);
        }
    }

    Object readRGB48(InputStream inputStream) throws IOException {
        if (this.fi.compression > 1) {
            return this.readCompressedRGB48(inputStream);
        }
        int n = 3;
        short[][] sArray = new short[n][this.nPixels];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = 0;
        int n3 = 65535;
        int n4 = 0;
        if (this.fi.stripLengths == null) {
            this.fi.stripLengths = new int[this.fi.stripOffsets.length];
            this.fi.stripLengths[0] = this.width * this.height * this.bytesPerPixel;
        }
        for (int i = 0; i < this.fi.stripOffsets.length; ++i) {
            int n5;
            int n6;
            long l;
            if (i > 0 && (l = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                dataInputStream.skip(l);
            }
            if ((n6 = this.fi.stripLengths[i]) > (n5 = (this.nPixels - n2) * n * 2)) {
                n6 = n5;
            }
            byte[] byArray = new byte[n6];
            dataInputStream.readFully(byArray);
            int n7 = 0;
            boolean bl = this.fi.intelByteOrder;
            for (int j = 0; j < n6; j += 2) {
                int n8 = bl ? (byArray[j + 1] & 0xFF) << 8 | byArray[j] & 0xFF : (byArray[j] & 0xFF) << 8 | byArray[j + 1] & 0xFF;
                if (n8 < n3) {
                    n3 = n8;
                }
                if (n8 > n4) {
                    n4 = n8;
                }
                sArray[n7][n2] = (short)n8;
                if (++n7 != n) continue;
                n7 = 0;
                ++n2;
            }
            this.showProgress(i + 1, this.fi.stripOffsets.length);
        }
        this.min = n3;
        this.max = n4;
        return sArray;
    }

    Object readCompressedRGB48(InputStream inputStream) throws IOException {
        if (this.fi.compression == 3) {
            throw new IOException("ImageJ cannot open 48-bit LZW compressed TIFFs with predictor");
        }
        int n = 3;
        short[][] sArray = new short[n][this.nPixels];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = 0;
        int n3 = 65535;
        int n4 = 0;
        for (int i = 0; i < this.fi.stripOffsets.length; ++i) {
            long l;
            if (i > 0 && (l = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                dataInputStream.skip(l);
            }
            int n5 = this.fi.stripLengths[i];
            byte[] byArray = new byte[n5];
            dataInputStream.readFully(byArray);
            byArray = this.uncompress(byArray);
            n5 = byArray.length;
            if (n5 % 2 != 0) {
                --n5;
            }
            int n6 = 0;
            boolean bl = this.fi.intelByteOrder;
            for (int j = 0; j < n5 && n2 < this.nPixels; j += 2) {
                int n7 = bl ? (byArray[j + 1] & 0xFF) << 8 | byArray[j] & 0xFF : (byArray[j] & 0xFF) << 8 | byArray[j + 1] & 0xFF;
                if (n7 < n3) {
                    n3 = n7;
                }
                if (n7 > n4) {
                    n4 = n7;
                }
                sArray[n6][n2] = (short)n7;
                if (++n6 != n) continue;
                n6 = 0;
                ++n2;
            }
            this.showProgress(i + 1, this.fi.stripOffsets.length);
        }
        this.min = n3;
        this.max = n4;
        return sArray;
    }

    Object readRGB48Planar(InputStream inputStream) throws IOException {
        short[] sArray = this.read16bitImage(inputStream);
        short[] sArray2 = this.read16bitImage(inputStream);
        short[] sArray3 = this.read16bitImage(inputStream);
        Object[] objectArray = new Object[]{sArray, sArray2, sArray3};
        return objectArray;
    }

    short[] read12bitImage(InputStream inputStream) throws IOException {
        int n = (int)((double)this.width * 1.5);
        if ((this.width & 1) == 1) {
            ++n;
        }
        byte[] byArray = new byte[n * this.height];
        short[] sArray = new short[this.nPixels];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(byArray);
        block0: for (int i = 0; i < this.height; ++i) {
            int n2 = i * n;
            int n3 = i * this.width;
            int n4 = 0;
            while (n4 < this.width) {
                sArray[n3 + n4] = (short)((byArray[n2] & 0xFF) * 16 + (byArray[n2 + 1] >> 4 & 0xF));
                if (++n4 == this.width) continue block0;
                sArray[n3 + n4] = (short)((byArray[n2 + 1] & 0xF) * 256 + (byArray[n2 + 2] & 0xFF));
                ++n4;
                n2 += 3;
            }
        }
        return sArray;
    }

    float[] read24bitImage(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[this.width * 3];
        float[] fArray = new float[this.nPixels];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        for (int i = 0; i < this.height; ++i) {
            dataInputStream.readFully(byArray);
            int n = 0;
            for (int j = 0; j < this.width; ++j) {
                int n2 = byArray[n++] & 0xFF;
                int n3 = byArray[n++] & 0xFF;
                int n4 = byArray[n++] & 0xFF;
                fArray[j + i * this.width] = n4 << 16 | n3 << 8 | n2;
            }
        }
        return fArray;
    }

    byte[] read1bitImage(InputStream inputStream) throws IOException {
        if (this.fi.compression == 2) {
            throw new IOException("ImageJ cannot open 1-bit LZW compressed TIFFs");
        }
        int n = (int)Math.ceil((double)this.width / 8.0);
        int n2 = n * this.height;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[this.nPixels];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(byArray);
        for (int i = 0; i < this.height; ++i) {
            int n3 = i * n;
            int n4 = i * this.width;
            for (int j = 0; j < n; ++j) {
                int n5 = byArray[n3 + j] & 0xFF;
                for (int k = 7; k >= 0; --k) {
                    int n6;
                    int n7 = n6 = (n5 & 1 << k) != 0 ? 255 : 0;
                    if (n4 >= byArray2.length) continue;
                    byArray2[n4++] = (byte)n6;
                }
            }
        }
        return byArray2;
    }

    void skip(InputStream inputStream) throws IOException {
        if (this.skipCount > 0L) {
            long l;
            int n = 0;
            for (long i = 0L; i < this.skipCount && (l = inputStream.skip(this.skipCount - i)) != -1L && ++n <= 5; i += l) {
            }
        }
        this.byteCount = this.width * this.height * this.bytesPerPixel;
        if (this.fi.fileType == 8) {
            int n = this.width / 8;
            int n2 = this.width % 8;
            if (n2 > 0) {
                ++n;
            }
            this.byteCount = n * this.height;
        }
        this.nPixels = this.width * this.height;
        this.bufferSize = this.byteCount / 25;
        this.bufferSize = this.bufferSize < 8192 ? 8192 : this.bufferSize / 8192 * 8192;
    }

    public Object readPixels(InputStream inputStream) {
        this.startTime = System.currentTimeMillis();
        try {
            Object object;
            switch (this.fi.fileType) {
                case 0: 
                case 5: {
                    this.bytesPerPixel = 1;
                    this.skip(inputStream);
                    object = this.read8bitImage(inputStream);
                    break;
                }
                case 1: 
                case 2: {
                    this.bytesPerPixel = 2;
                    this.skip(inputStream);
                    object = this.read16bitImage(inputStream);
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    this.bytesPerPixel = 4;
                    this.skip(inputStream);
                    object = this.read32bitImage(inputStream);
                    break;
                }
                case 16: {
                    this.bytesPerPixel = 8;
                    this.skip(inputStream);
                    object = this.read64bitImage(inputStream);
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 15: 
                case 18: {
                    this.bytesPerPixel = this.fi.getBytesPerPixel();
                    this.skip(inputStream);
                    object = this.readChunkyRGB(inputStream);
                    break;
                }
                case 7: {
                    this.bytesPerPixel = 3;
                    this.skip(inputStream);
                    object = this.readPlanarRGB(inputStream);
                    break;
                }
                case 8: {
                    this.bytesPerPixel = 1;
                    this.skip(inputStream);
                    object = this.read1bitImage(inputStream);
                    break;
                }
                case 12: {
                    this.bytesPerPixel = 6;
                    this.skip(inputStream);
                    object = this.readRGB48(inputStream);
                    break;
                }
                case 17: {
                    this.bytesPerPixel = 2;
                    this.skip(inputStream);
                    object = this.readRGB48Planar(inputStream);
                    break;
                }
                case 13: {
                    this.skip(inputStream);
                    short[] sArray = this.read12bitImage(inputStream);
                    object = sArray;
                    break;
                }
                case 14: {
                    this.skip(inputStream);
                    object = this.read24bitImage(inputStream);
                    break;
                }
                default: {
                    object = null;
                }
            }
            this.showProgress(1, 1);
            return object;
        }
        catch (IOException iOException) {
            IJ.log("" + iOException);
            return null;
        }
    }

    public Object readPixels(InputStream inputStream, long l) {
        this.skipCount = l;
        this.showProgressBar = false;
        Object object = this.readPixels(inputStream);
        if (this.eofErrorCount > 0) {
            return null;
        }
        return object;
    }

    public Object readPixels(String string) {
        InputStream inputStream;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            IJ.log("" + malformedURLException);
            return null;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            IJ.log("" + iOException);
            return null;
        }
        return this.readPixels(inputStream);
    }

    byte[] uncompress(byte[] byArray) {
        return this.uncompress(byArray, -1);
    }

    byte[] uncompress(byte[] byArray, int n) {
        if (this.fi.compression == 5) {
            return this.packBitsUncompress(byArray, this.fi.rowsPerStrip * this.fi.width * this.fi.getBytesPerPixel());
        }
        if (this.fi.compression == 2 || this.fi.compression == 3) {
            return this.lzwUncompress(byArray, n);
        }
        return byArray;
    }

    public byte[] lzwUncompress(byte[] byArray) {
        return this.lzwUncompress(byArray, -1);
    }

    public byte[] lzwUncompress(byte[] byArray, int n) {
        int n2;
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        byte[][] byArray2 = new byte[4096][1];
        int n3 = 9;
        int n4 = 258;
        int n5 = -1;
        ByteVector byteVector = new ByteVector(8192);
        BitBuffer bitBuffer = new BitBuffer(byArray);
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        while (byteVector.size() < n && (n2 = bitBuffer.getBits(n3)) != 257 && n2 != -1) {
            ByteVector byteVector2;
            if (n2 == 256) {
                for (int i = 0; i < 256; ++i) {
                    byArray2[i][0] = (byte)i;
                }
                n4 = 258;
                n3 = 9;
                n2 = bitBuffer.getBits(n3);
                if (n2 == 257 || n2 == -1) break;
                byteVector.add(byArray2[n2]);
                n5 = n2;
                continue;
            }
            if (n2 < n4) {
                byteVector.add(byArray2[n2]);
                byteVector2 = new ByteVector(byArray3);
                byteVector2.add(byArray2[n5]);
                byteVector2.add(byArray2[n2][0]);
                byArray2[n4] = byteVector2.toByteArray();
                n5 = n2;
                ++n4;
            } else {
                byteVector2 = new ByteVector(byArray4);
                byteVector2.add(byArray2[n5]);
                byteVector2.add(byArray2[n5][0]);
                byte[] byArray5 = byteVector2.toByteArray();
                byteVector.add(byArray5);
                byArray2[n4] = byArray5;
                n5 = n2;
                ++n4;
            }
            if (n4 == 511) {
                n3 = 10;
            }
            if (n4 == 1023) {
                n3 = 11;
            }
            if (n4 != 2047) continue;
            n3 = 12;
        }
        return byteVector.toByteArray();
    }

    public byte[] packBitsUncompress(byte[] byArray, int n) {
        if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        ByteVector byteVector = new ByteVector(1024);
        int n2 = 0;
        while (byteVector.size() < n && n2 < byArray.length) {
            byte by;
            byte by2;
            if ((by2 = byArray[n2++]) >= 0) {
                byte[] byArray2 = new byte[by2 + 1];
                for (by = 0; by < by2 + 1; ++by) {
                    byArray2[by] = byArray[n2++];
                }
                byteVector.add(byArray2);
                byArray2 = null;
                continue;
            }
            if (by2 == -128) continue;
            int n3 = -by2 + 1;
            by = byArray[n2++];
            for (int i = 0; i < n3; ++i) {
                byteVector.add(by);
            }
        }
        return byteVector.toByteArray();
    }
}

