/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloodFiller;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class Binary
implements PlugInFilter {
    String arg;
    ImagePlus imp;
    static int iterations = 1;
    static int count = 1;
    int foreground;
    int background;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(Binary.class);
        if (arg.equals("options")) {
            this.showDialog();
            return 4096;
        }
        if (imp != null && (imp.getType() == 0 || imp.getType() == 3)) {
            ImageStatistics stats = imp.getStatistics();
            if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
                IJ.error("8-bit binary (black and white only) image required.");
                return 4096;
            }
        }
        if (imp != null && arg.equals("skel")) {
            imp.killRoi();
        }
        return IJ.setupDialog(imp, 67);
    }

    public void run(ImageProcessor ip) {
        int n = this.foreground = Prefs.blackBackground ? 255 : 0;
        if (ip.isInvertedLut()) {
            this.foreground = 255 - this.foreground;
        }
        this.background = 255 - this.foreground;
        ip.setSnapshotCopyMode(true);
        if (this.arg.equals("erode")) {
            this.erode(ip);
        } else if (this.arg.equals("dilate")) {
            this.dilate(ip);
        } else if (this.arg.equals("open")) {
            this.open(ip);
        } else if (this.arg.equals("close")) {
            this.close(ip);
        } else if (this.arg.equals("outline")) {
            this.outline(ip);
        } else if (this.arg.equals("skel")) {
            this.skeletonize(ip);
        } else if (this.arg.equals("fill")) {
            this.fill(ip, this.foreground, this.background);
        }
        ip.setSnapshotCopyMode(false);
    }

    void erode(ImageProcessor ip) {
        for (int i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).erode(count, this.background);
        }
    }

    void dilate(ImageProcessor ip) {
        for (int i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).dilate(count, this.background);
        }
    }

    void open(ImageProcessor ip) {
        int i;
        for (i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).erode(count, this.background);
        }
        for (i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).dilate(count, this.background);
        }
    }

    void close(ImageProcessor ip) {
        int i;
        for (i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).dilate(count, this.background);
        }
        for (i = 0; i < iterations; ++i) {
            ((ByteProcessor)ip).erode(count, this.background);
        }
    }

    void outline(ImageProcessor ip) {
        if (Prefs.blackBackground) {
            ip.invert();
        }
        ((ByteProcessor)ip).outline();
        if (Prefs.blackBackground) {
            ip.invert();
        }
    }

    void skeletonize(ImageProcessor ip) {
        if (Prefs.blackBackground) {
            ip.invert();
        }
        boolean edgePixels = this.hasEdgePixels(ip);
        ImageProcessor ip2 = this.expand(ip, edgePixels);
        ((ByteProcessor)ip2).skeletonize();
        ip = this.shrink(ip, ip2, edgePixels);
        if (Prefs.blackBackground) {
            ip.invert();
        }
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("Binary Options");
        gd.addNumericField("Iterations (1-25):", iterations, 0, 3, "");
        gd.addNumericField("Count (1-8):", count, 0, 3, "");
        gd.addCheckbox("Black Background", Prefs.blackBackground);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int n = (int)gd.getNextNumber();
        Prefs.blackBackground = gd.getNextBoolean();
        if (n > 25) {
            n = 25;
        }
        if (n < 1) {
            n = 1;
        }
        iterations = n;
        count = (int)gd.getNextNumber();
        if (count < 1) {
            count = 1;
        }
        if (count > 8) {
            count = 8;
        }
    }

    boolean hasEdgePixels(ImageProcessor ip) {
        int y;
        int x;
        int width = ip.getWidth();
        int height = ip.getHeight();
        boolean edgePixels = false;
        for (x = 0; x < width; ++x) {
            if (ip.getPixel(x, 0) != this.foreground) continue;
            edgePixels = true;
        }
        for (x = 0; x < width; ++x) {
            if (ip.getPixel(x, height - 1) != this.foreground) continue;
            edgePixels = true;
        }
        for (y = 0; y < height; ++y) {
            if (ip.getPixel(0, y) != this.foreground) continue;
            edgePixels = true;
        }
        for (y = 0; y < height; ++y) {
            if (ip.getPixel(height - 1, y) != this.foreground) continue;
            edgePixels = true;
        }
        return edgePixels;
    }

    ImageProcessor expand(ImageProcessor ip, boolean hasEdgePixels) {
        if (hasEdgePixels) {
            ImageProcessor ip2 = ip.createProcessor(ip.getWidth() + 2, ip.getHeight() + 2);
            if (this.foreground == 0) {
                ip2.setColor(255);
                ip2.fill();
            }
            ip2.insert(ip, 1, 1);
            return ip2;
        }
        return ip;
    }

    ImageProcessor shrink(ImageProcessor ip, ImageProcessor ip2, boolean hasEdgePixels) {
        if (hasEdgePixels) {
            int width = ip.getWidth();
            int height = ip.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    ip.putPixel(x, y, ip2.getPixel(x + 1, y + 1));
                }
            }
        }
        return ip;
    }

    void fill(ImageProcessor ip, int foreground, int background) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        FloodFiller ff = new FloodFiller(ip);
        ip.setColor(127);
        for (int y = 0; y < height; ++y) {
            if (ip.getPixel(0, y) == background) {
                ff.fill(0, y);
            }
            if (ip.getPixel(width - 1, y) != background) continue;
            ff.fill(width - 1, y);
        }
        for (int x = 0; x < width; ++x) {
            if (ip.getPixel(x, 0) == background) {
                ff.fill(x, 0);
            }
            if (ip.getPixel(x, height - 1) != background) continue;
            ff.fill(x, height - 1);
        }
        byte[] pixels = (byte[])ip.getPixels();
        int n = width * height;
        for (int i = 0; i < n; ++i) {
            pixels[i] = pixels[i] == 127 ? (byte)background : (byte)foreground;
        }
    }
}

