/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.util.Shell;

public class ShellBasedUnixGroupsMapping
implements GroupMappingServiceProvider {
    private static final Log LOG = LogFactory.getLog(ShellBasedUnixGroupsMapping.class);

    @Override
    public List<String> getGroups(String user) throws IOException {
        return ShellBasedUnixGroupsMapping.getUnixGroups(user);
    }

    private static List<String> getUnixGroups(String user) throws IOException {
        String result = "";
        try {
            result = Shell.execCommand(Shell.getGroupsForUserCommand(user));
        }
        catch (Shell.ExitCodeException e) {
            LOG.warn((Object)("got exception trying to get groups for user " + user), (Throwable)e);
        }
        StringTokenizer tokenizer = new StringTokenizer(result);
        LinkedList<String> groups = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
        return groups;
    }
}

