% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculatePowerBand.R
\name{getNormSpectralUnits}
\alias{getNormSpectralUnits}
\title{Normalized Spectral Units}
\usage{
getNormSpectralUnits(HRVData,
  indexFreqAnalysis = length(HRVData$FreqAnalysis), VLFnormalization = T)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information related to it}

\item{indexFreqAnalysis}{Reference to the data structure that contains the spectrogram analysis}

\item{VLFnormalization}{Logical value. If TRUE (default), the function
normalizes LF and HF power series by its sum. If FALSE, the function computes
VLF, LF and HF power series  by its sum.}
}
\value{
The \emph{getNormSpectralUnits} returns a list storing the resulting
normalized power-band series. Note that this list is not stored in the 
\emph{HRVData} structure.
}
\description{
Calculates the spectrogram bands in normalized units
}
\details{
The default behaviour of this function computes the normalized power
time series in the LF and HF bands following the Task Force recommendations:

\deqn{normalized\_LF = LF\_power / (total\_power - VLF\_power - ULF\_power)}{
normalized_LF = LF_power / (total_power - VLF_power - ULF_power)}
\deqn{normalized\_HF = HF\_power / (total\_power - VLF\_power -ULF\_power)}{
normalized_HF = HF_power / (total_power - VLF_power -ULF-power)}

If \emph{VLFnormalization} is set to FALSE, the functions computes:
\deqn{normalized\_VLF = VLF\_power / (total\_power - ULF\_power)}{
normalized_VLF = VLF_power / (total_power - ULF_power)}
\deqn{normalized\_LF = LF\_power / (total\_power - ULF\_power)}{
normalized_LF = LF_power / (total_power - ULF_power)}
\deqn{normalized\_HF = HF\_power / (total\_power - ULF\_power)}{
normalized_HF = HF_power / (total_power - ULF_power)}

The resulting time series are returned in a list. Note that before using this
function, the spectrogram should be computed with the \emph{CalculatePowerBand}
function.
}
\examples{
\dontrun{
# load some data...
data(HRVProcessedData)
hd = HRVProcessedData
# Perform some spectral analysis and normalize the results
hd = CreateFreqAnalysis(hd)
hd = CalculatePowerBand(hd,indexFreqAnalysis = 1,shift=30,size=60)
normUnits = getNormSpectralUnits(hd)
# plot the normalized time series
par(mfrow=c(2,1))
plot(normUnits$Time, normUnits$LF, xlab="Time", ylab="normalized LF",
     main="normalized LF",type="l")
plot(normUnits$Time, normUnits$HF, xlab="Time", ylab="normalized HF",
     main="normalized HF",type="l")
par(mfrow=c(1,1))

}
}
\references{
Camm, A. J., et al. "Heart rate variability: standards of measurement, physiological interpretation and clinical use.
Task Force of the European Society of Cardiology and the North American Society of
Pacing and Electrophysiology." Circulation 93.5 (1996): 1043-1065.
}

