% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gspaceMethods.R
\name{GraphSpace}
\alias{GraphSpace}
\title{Constructor of GraphSpace-class objects}
\usage{
GraphSpace(g, mar = 0.1, layout = NULL, image = NULL, verbose = TRUE)
}
\arguments{
\item{g}{An \code{\link[igraph]{igraph}} object. It must include graph 
coordinates assigned to \code{x} and \code{y} vertex attributes, and
vertex labels assigned to \code{name} vertex attribute.}

\item{mar}{A single numeric value (in \code{[0,1]}) indicating the size of
the outer margins as a fraction of the graph space.
Note: When an image is provided, \code{mar} is a fraction of image margins.}

\item{layout}{An optional numeric matrix with two columns for \code{x} 
and \code{y} coordinates.}

\item{image}{An optional background image. When provided, \code{x} and 
\code{y} coordinates must represent pixel positions in the image space.}

\item{verbose}{A single logical value specifying to display detailed 
messages (when \code{verbose=TRUE}) or not (when \code{verbose=FALSE}).}
}
\value{
A \linkS4class{GraphSpace} class object.
}
\description{
\code{GraphSpace} is a constructor of
GraphSpace-class objects.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

gs <- GraphSpace(gtoy1)

}
\seealso{
\code{\link{plotGraphSpace}}
}
\author{
Sysbiolab.
}
