% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mat_2scipy_sparse}
\alias{mat_2scipy_sparse}
\title{conversion of an R matrix to a scipy sparse matrix}
\usage{
mat_2scipy_sparse(x, format = "sparse_row_matrix")
}
\arguments{
\item{x}{a data matrix}

\item{format}{a character string. Either \emph{"sparse_row_matrix"} or \emph{"sparse_column_matrix"}}
}
\description{
conversion of an R matrix to a scipy sparse matrix
}
\details{
This function allows the user to convert an R matrix to a scipy sparse matrix. This is useful because the Regularized Greedy Forest algorithm accepts only python sparse matrices as input.
}
\examples{

if (reticulate::py_available() && reticulate::py_module_available("scipy")) {

  library(RGF)

  set.seed(1)

  x = matrix(runif(1000), nrow = 100, ncol = 10)

  res = mat_2scipy_sparse(x)

  print(dim(x))

  print(res$shape)
}
}
\references{
https://docs.scipy.org/doc/scipy/reference/sparse.html
}
