% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cval.r
\name{print.cval}
\alias{print.cval}
\title{Print a rgcca_cv object}
\usage{
\method{print}{cval}(x, type = "sd", ...)
}
\arguments{
\item{x}{A rgcca_cv object (see \link{rgcca_cv})}

\item{type}{A string indicating the statistics depicted in the boxplot:
\itemize{
\item "sd" (default): the middle bar corresponds to the mean and limits of
the boxes are given by the mean plus or minus the standard deviation.
\item "quantile": the middle bar corresponds to the median and limits of
the boxes are given by the 25\% and 75\% quantiles.
}}

\item{...}{Other parameters used in print (for the displaying of matrices).}
}
\value{
none
}
\description{
Print a fitted rgcca_cv object. Parameters of the
analysis, tuning parameters and statistics for each set of
parameters are displayed.
}
\examples{
data("Russett")
blocks <- list(
  agriculture = Russett[, seq(3)],
  industry = Russett[, 4:5],
  politic = Russett[, 6:8]
)
res <- rgcca_cv(blocks,
  response = 3, method = "rgcca", par_type = "tau",
  par_value = c(0, 0.2, 0.3), n_run = 1, n_cores = 1,
  verbose = TRUE
)
print(res)
}
