/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import freak.core.population.Genotype;
import java.util.BitSet;

public class BitStringGenotype
extends Genotype {
    private BitSet genotype;
    private int dimension;

    public BitStringGenotype(BitSet bs, int dim) {
        this.genotype = bs;
        this.dimension = dim;
    }

    public BitStringGenotype(boolean[] gen) {
        this.dimension = gen.length;
        this.genotype = new BitSet(this.dimension);
        int i = 0;
        while (i < this.dimension) {
            this.genotype.set(i, gen[i]);
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BitStringGenotype)) {
            return false;
        }
        BitStringGenotype bsg = (BitStringGenotype)o;
        if (bsg.dimension != this.dimension) {
            return false;
        }
        return this.genotype.equals(bsg.genotype);
    }

    public int hashCode() {
        return this.genotype.hashCode();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this.dimension);
        int i = 0;
        while (i < this.dimension) {
            s.append(this.genotype.get(i) ? (char)'1' : '0');
            ++i;
        }
        return s.toString();
    }

    public BitSet getBitSet() {
        return this.genotype;
    }

    public int size() {
        return this.dimension;
    }

    public void set(int bitIndex, boolean value) {
        if (bitIndex < 0 || bitIndex >= this.dimension) {
            throw new IndexOutOfBoundsException();
        }
        this.genotype.set(bitIndex, value);
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.dimension) {
            throw new IndexOutOfBoundsException();
        }
        return this.genotype.get(bitIndex);
    }

    public void flip(int bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.dimension) {
            throw new IndexOutOfBoundsException();
        }
        this.genotype.flip(bitIndex);
    }

    public boolean[] getBooleanArray() {
        boolean[] result = new boolean[this.dimension];
        int i = 0;
        while (i < this.dimension) {
            result[i] = this.genotype.get(i);
            ++i;
        }
        return result;
    }

    public Object clone() {
        BitStringGenotype copy;
        try {
            copy = (BitStringGenotype)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.toString());
        }
        copy.genotype = (BitSet)this.genotype.clone();
        return copy;
    }
}

