/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.util;

import freak.module.fitness.pointset.math.EqSolvers;
import freak.module.fitness.pointset.math.matrix.Matrix;
import freak.module.fitness.pointset.math.matrix.Vector;
import freak.module.fitness.pointset.math.matrix.view.MatrixSimpleOperation;
import freak.module.fitness.pointset.math.matrix.view.NormalView;
import freak.module.fitness.pointset.math.matrix.view.TransposeView;
import freak.module.fitness.pointset.math.matrix.view.VectorView;
import freak.module.searchspace.PointSet;
import java.io.Serializable;

public class HyperPlane
implements Serializable {
    protected int dimension;
    protected VectorView parameter;

    public HyperPlane() {
    }

    public HyperPlane(PointSet.Point[] supportPoints) {
        this.computeParam(supportPoints);
    }

    public int getDimension() {
        return this.dimension;
    }

    public VectorView getParameter() {
        return this.parameter;
    }

    public void computeParam(PointSet.Point[] supportPoints) {
        this.dimension = supportPoints[0].getDimension();
        if (supportPoints.length < this.dimension) {
            throw new Error("Not enough points to determine the hyperplane.");
        }
        Matrix m = new Matrix(this.dimension);
        Vector b = new Vector(this.dimension);
        NormalView vm = new NormalView(m);
        VectorView vb = new VectorView(b);
        try {
            int i = 0;
            while (i < this.dimension) {
                vm.set(i, 0, 1.0);
                vb.set(i, supportPoints[i].getK(0));
                int j = 1;
                while (j < this.dimension) {
                    vm.set(i, j, supportPoints[i].getK(j));
                    ++j;
                }
                ++i;
            }
            TransposeView tm = new TransposeView(m);
            MatrixSimpleOperation sop = new MatrixSimpleOperation(tm);
            NormalView tmm = sop.multMatrix(vm);
            NormalView tmbm = sop.multMatrix(vb);
            Vector tmb = new Vector(tmbm);
            EqSolvers eqSolver = new EqSolvers(tmm.getMatrix(), tmb);
            this.parameter = new VectorView(eqSolver.solve());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

