/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.SearchSpace;
import freak.core.util.FreakMath;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class KPosMutation
extends Mutation
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private int k = 1;

    public KPosMutation(OperatorGraph graph) {
        super(graph);
    }

    public void initialize() {
        super.initialize();
        int dim = ((HasDimension)((Object)this.getGenotypeSearchSpace())).getDimension();
        if (this.k > dim) {
            this.k = dim;
        }
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof GeneralString) && !(searchspace instanceof BitString)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    protected Individual doMutation(Individual ind) {
        int dimension = ((HasDimension)((Object)this.graph.getSchedule().getGenotypeSearchSpace())).getDimension();
        int[] flippos = FreakMath.getKofN(this.graph.getSchedule(), this.k, dimension);
        Genotype gt = ind.getGenotype();
        if (gt instanceof BitStringGenotype) {
            BitStringGenotype bs = (BitStringGenotype)((BitStringGenotype)gt).clone();
            int i = 0;
            while (i < this.k) {
                bs.flip(flippos[i]);
                ++i;
            }
            return new Individual(this.graph.getSchedule(), bs, new Individual[]{ind});
        }
        GeneralStringGenotype geno = (GeneralStringGenotype)((GeneralStringGenotype)gt).clone();
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int i = 0;
        while (i < this.k) {
            geno.flip(flippos[i], re);
            ++i;
        }
        return new Individual(this.graph.getSchedule(), geno, new Individual[]{ind});
    }

    public void setPropertyK(Integer num) {
        if (num >= 0 && num <= ((HasDimension)((Object)this.getGenotypeSearchSpace())).getDimension()) {
            this.k = num;
        }
    }

    public Integer getPropertyK() {
        return new Integer(this.k);
    }

    public String getLongDescriptionForkK() {
        if (this.graph.getSchedule().getGenotypeSearchSpace() instanceof BitString) {
            return "Number of positions to flip.";
        }
        return "Number of positions to alter.";
    }

    public String getShortDescriptionForK() {
        return "k";
    }

    public String getDescription() {
        if (this.graph.getSchedule().getGenotypeSearchSpace() instanceof BitString) {
            return "Exactly k randomly chosen bits are flipped.";
        }
        return "Exactly k randomly chosen positions are altered. Altering a position means that a character randomly chosen among the remaining characters is assigned to this position.";
    }

    public String getName() {
        if (this.graph.getSchedule().getGenotypeSearchSpace() instanceof BitString) {
            return "k-Bit Mutation";
        }
        return "k-Char Mutation";
    }
}

