/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.bitstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;

public class AsynchronousMutation
extends Mutation
implements Configurable {
    private double k = 1.0;

    public AsynchronousMutation(OperatorGraph graph) {
        super(graph);
    }

    public void initialize() {
        super.initialize();
        int dim = ((HasDimension)((Object)this.getGenotypeSearchSpace())).getDimension();
        if (this.k > (double)dim) {
            this.k = dim;
        }
    }

    public void setPropertyK(Double num) {
        if (num >= 0.0 && num <= (double)((BitString)this.getGenotypeSearchSpace()).getDimension()) {
            this.k = num;
        }
    }

    public Double getPropertyK() {
        return new Double(this.k);
    }

    public String getLongDescriptionForkK() {
        return "On the average k one-bits and k null-bits are flipped.";
    }

    public String getShortDescriptionForK() {
        return "k";
    }

    protected int getNextFlipPosition(double prob, int max) {
        double logbasis = Math.log(1.0 - prob);
        int doubleImprecision = logbasis == 0.0 ? Integer.MAX_VALUE : (int)Math.floor(Math.log(Math.pow(2.0, -47.0)) / logbasis);
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int nextPosition = logbasis == 0.0 ? -1 : (int)Math.floor(Math.log(re.raw()) / logbasis);
        if (doubleImprecision < nextPosition) {
            nextPosition = max > doubleImprecision ? this.getNextFlipPosition(prob, max - doubleImprecision - 1) + doubleImprecision + 1 : -1;
        }
        if (nextPosition > max) {
            nextPosition = -1;
        }
        return nextPosition;
    }

    protected Individual doMutation(Individual ind) {
        int dimension = ((BitString)this.graph.getSchedule().getGenotypeSearchSpace()).getDimension();
        BitStringGenotype bs = (BitStringGenotype)((BitStringGenotype)ind.getGenotype()).clone();
        int numberOfOnes = bs.getBitSet().cardinality();
        int onesCount = 0;
        int nullsCount = 0;
        int[] ones = new int[numberOfOnes];
        int[] nulls = new int[dimension - numberOfOnes];
        int i = 0;
        while (i < dimension) {
            if (bs.get(i)) {
                ones[onesCount++] = i;
            } else {
                nulls[nullsCount++] = i;
            }
            ++i;
        }
        double prob = this.k / (double)onesCount;
        int startindex = 0;
        int nextPos = this.getNextFlipPosition(prob, onesCount - startindex - 1);
        while (nextPos != -1) {
            bs.flip(ones[startindex + nextPos]);
            nextPos = this.getNextFlipPosition(prob, onesCount - (startindex += nextPos + 1) - 1);
        }
        prob = this.k / (double)nullsCount;
        startindex = 0;
        nextPos = this.getNextFlipPosition(prob, nullsCount - startindex - 1);
        while (nextPos != -1) {
            bs.flip(nulls[startindex + nextPos]);
            nextPos = this.getNextFlipPosition(prob, nullsCount - (startindex += nextPos + 1) - 1);
        }
        return new Individual(this.graph.getSchedule(), bs, new Individual[]{ind});
    }

    public String getDescription() {
        return "This operator flips one-bits independently with probability k/CountOfOnesInBitString and null-bits independently with probability k/CountOfNullsInBitString. On the average k one-bits and k null-bits are flipped.";
    }

    public String getName() {
        return "Asynchronous Mutation";
    }
}

