/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import bsh.EvalError;
import bsh.Interpreter;
import freak.Freak;
import freak.core.control.Batch;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.PropertyManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class BatchList
implements Serializable {
    private List batches = new ArrayList();
    private Map configurationCodes = new HashMap();

    protected BatchList() {
    }

    public void add(Batch batch, boolean applyConfigurationCode) {
        this.batches.add(batch);
        if (applyConfigurationCode) {
            this.applyConfigurationCodes(batch);
        }
    }

    public void set(int index, Batch batch) {
        this.batches.set(index, batch);
    }

    public void removeBatch(int index) {
        this.batches.remove(index);
    }

    public Batch get(int index) {
        Batch batch = (Batch)this.batches.get(index);
        return batch;
    }

    private void applyConfigurationCodes(Batch batch) {
        Iterator iter = this.configurationCodes.keySet().iterator();
        while (iter.hasNext()) {
            this.applyConfigurationCode(batch, (Configurable)iter.next());
        }
    }

    private void applyConfigurationCode(Batch batch, Configurable module) {
        Configuration old_config;
        block11: {
            old_config = module.getConfiguration();
            Configuration config = null;
            try {
                config = batch.getConfiguration(module);
                if (config != null) {
                    module.setConfiguration(config);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            String code = (String)this.configurationCodes.get(module);
            Interpreter i = new Interpreter();
            try {
                i.set("batch", this.batches.indexOf(batch));
                String[] pNames = PropertyManager.getListOfPropertyNames(module);
                int j = 0;
                while (j < pNames.length) {
                    try {
                        i.set(pNames[j], PropertyManager.getProperty(module, pNames[j]));
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                    ++j;
                }
                i.eval(code);
                j = 0;
                while (j < pNames.length) {
                    if (i.get(pNames[j]) != null) {
                        PropertyManager.setProperty(module, pNames[j], i.get(pNames[j]));
                    }
                    ++j;
                }
                batch.putConfiguration(module, module.getConfiguration());
            }
            catch (EvalError e) {
                Freak.debug(e.toString(), 3);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IllegalArgumentException) break block11;
                throw e;
            }
        }
        module.setConfiguration(old_config);
    }

    public void clear() {
        this.batches.clear();
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.batches).iterator();
    }

    public int size() {
        return this.batches.size();
    }

    public void setConfigurationCode(Configurable module, String code) {
        if (code.trim().equals("")) {
            this.configurationCodes.remove(module);
        } else {
            this.configurationCodes.put(module, code);
        }
        for (Batch batch : this.batches) {
            this.applyConfigurationCode(batch, module);
        }
    }

    public String getConfigurationCode(Configurable module) {
        if (this.configurationCodes.get(module) != null) {
            return (String)this.configurationCodes.get(module);
        }
        String code = "// variable batch contains the current batch number (starting from 0)\n\n";
        String[] pNames = PropertyManager.getListOfPropertyNames(module);
        int pCount = pNames.length;
        int i = 0;
        while (i < pCount) {
            try {
                Class<?> c = PropertyManager.getProperty(module, pNames[i]).getClass();
                int arrayCount = 0;
                while (c.isArray()) {
                    c = c.getComponentType();
                    ++arrayCount;
                }
                code = String.valueOf(code) + c.getName();
                while (arrayCount-- > 0) {
                    code = String.valueOf(code) + "[]";
                }
                code = String.valueOf(code) + " " + pNames[i] + ";\n";
            }
            catch (UnsupportedOperationException c) {
                // empty catch block
            }
            ++i;
        }
        code = String.valueOf(code) + "\n\n";
        i = 0;
        while (i < pCount) {
            try {
                String value = "";
                Object property = PropertyManager.getProperty(module, pNames[i]);
                if (property instanceof Number || property instanceof Boolean) {
                    value = property.toString();
                } else if (property instanceof String) {
                    value = "\"" + property + "\"";
                }
                value = value.trim();
                if (value.equals("")) {
                    code = String.valueOf(code) + "//" + pNames[i] + " = " + PropertyManager.getProperty(module, pNames[i]) + "\n";
                } else {
                    value.replaceAll("\n", " ");
                    code = String.valueOf(code) + "// " + pNames[i] + " = " + value + ";\n";
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            ++i;
        }
        return code;
    }

    public int getTotalRuns() {
        int result = 0;
        for (Batch batch : this.batches) {
            result += batch.getRuns();
        }
        return result;
    }
}

