/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.generalstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.module.fitness.generalstring.SSSPMultiObjective;
import freak.module.fitness.generalstring.SSSPSingleObjective;
import freak.module.searchspace.GeneralStringGenotype;

public class SSSPLocalMutation
extends Mutation {
    public SSSPLocalMutation(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        FitnessFunction f = schedule.getRealFitnessFunction();
        if (!(f instanceof SSSPMultiObjective) && !(f instanceof SSSPSingleObjective)) {
            throw new UnsupportedEnvironmentException("Only works in connection with a SSSP fitness function.");
        }
    }

    protected Individual doMutation(Individual ind) {
        int max;
        int min;
        GeneralStringGenotype geno = (GeneralStringGenotype)((GeneralStringGenotype)ind.getGenotype()).clone();
        int[] gt = geno.getIntArray();
        int dimension = ((HasDimension)((Object)this.graph.getSchedule().getGenotypeSearchSpace())).getDimension();
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int pos = re.choose(0, dimension - 1);
        if (gt[pos] > pos) {
            min = pos;
            max = gt[pos];
        } else {
            min = gt[pos];
            max = pos;
        }
        int newValue = re.choose(0, dimension - 2);
        if (newValue >= min) {
            ++newValue;
        }
        if (newValue >= max) {
            // empty if block
        }
        gt[pos] = ++newValue;
        return new Individual(this.graph.getSchedule(), geno, new Individual[]{ind});
    }

    public String getName() {
        return "SSSP Local Mutation";
    }

    public String getDescription() {
        return "This operator differs from the 1-Char-Mutation only in the point that the value of the i-th character is never set to i.";
    }
}

