/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.NoSuchIndividualException;
import freak.core.population.Population;

public class TournamentSelection
extends Selection
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private int tournamentSize = 1;
    private int noOfIndividualsToSelect = 1;

    public TournamentSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This operator works on single objective fitness functions only.");
        }
    }

    public IndividualList[] process(IndividualList[] original) {
        int i = 0;
        while (i < original.length) {
            if (original[i] == null) {
                throw new NoSuchIndividualException();
            }
            ++i;
        }
        IndividualList[] result = new IndividualList[]{new Population(this.graph.getSchedule(), this.noOfIndividualsToSelect)};
        Individual[] origin = original[0].toArray();
        FitnessFunction fitness = this.graph.getSchedule().getFitnessFunction();
        Individual[] tournament = new Individual[this.tournamentSize];
        double[] fValue = new double[this.tournamentSize];
        RandomElement randomGen = this.graph.getSchedule().getRandomElement();
        int i2 = 0;
        while (i2 < this.noOfIndividualsToSelect) {
            int j = 0;
            while (j < this.tournamentSize) {
                int number = randomGen.choose(0, origin.length - 1);
                tournament[j] = origin[number];
                fValue[j] = ((SingleObjectiveFitnessFunction)fitness).evaluate(origin[number], original[0]);
                ++j;
            }
            result[0].addIndividual(this.doTournament(tournament, fValue));
            ++i2;
        }
        return result;
    }

    public Integer getPropertyTournamentSize() {
        return new Integer(this.tournamentSize);
    }

    public void setPropertyTournamentSize(Integer tournamentSize) {
        this.tournamentSize = tournamentSize;
    }

    public String getShortDescriptionForTournamentSize() {
        return "Tournament size";
    }

    public String getLongDescriptionForTournamentSize() {
        return "The number of individuals contesting in a tournament.";
    }

    public Integer getPropertyNoOfIndividualsToSelect() {
        return new Integer(this.noOfIndividualsToSelect);
    }

    public void setPropertyNoOfIndividualsToSelect(Integer noOfIndividualsToSelect) {
        this.noOfIndividualsToSelect = noOfIndividualsToSelect;
        if (this.noOfIndividualsToSelect <= 0) {
            this.noOfIndividualsToSelect = 1;
        }
    }

    public String getShortDescriptionForNoOfIndividualsToSelect() {
        return "Selected individuals";
    }

    public String getLongDescriptionForNoOfIndividualsToSelect() {
        return "The number of individuals to be selected.";
    }

    private Individual doTournament(Individual[] individual, double[] fValue) {
        if (individual.length > 0) {
            int best = 0;
            int i = 1;
            while (i < individual.length) {
                if (fValue[i] > fValue[best]) {
                    best = i;
                }
                ++i;
            }
            return individual[best];
        }
        return null;
    }

    public String getName() {
        return "Tournament Selection";
    }

    public String getDescription() {
        return "Selects individuals as winners of tournaments.The individuals for the tournaments are chosen uniform randomly and the winner is put into selection. This procedure is repeated until the specified amount of individuals is selected.";
    }
}

