/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.initialization;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.GraphException;
import freak.core.graph.Initialization;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.fitness.generalstring.SSSPMultiObjective;
import freak.module.fitness.generalstring.SSSPSingleObjective;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class SSSPInitialization
extends Initialization {
    private int size = 1;

    public SSSPInitialization(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        FitnessFunction f = schedule.getRealFitnessFunction();
        if (!(f instanceof SSSPMultiObjective) && !(f instanceof SSSPSingleObjective)) {
            throw new UnsupportedEnvironmentException("Only works in connection with a SSSP fitness function.");
        }
        if (!(schedule.getGenotypeSearchSpace() instanceof GeneralString)) {
            throw new UnsupportedEnvironmentException("Only works on the search space GeneralString.");
        }
        GeneralString sp = (GeneralString)schedule.getGenotypeSearchSpace();
        if (sp.getPropertyNumberOfChars() != sp.getDimension() + 1) {
            throw new UnsupportedEnvironmentException("The number of characters must equals the dimension+1.");
        }
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        IndividualList[] result = new IndividualList[]{new Population(this.graph.getSchedule(), this.size)};
        GeneralString sp = (GeneralString)this.graph.getSchedule().getGenotypeSearchSpace();
        int numChar = sp.getPropertyNumberOfChars();
        int dimension = sp.getDimension();
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int i = 0;
        while (i < this.size) {
            int[] gt = new int[dimension];
            int j = 0;
            while (j < dimension) {
                gt[j] = re.choose(0, numChar - 2);
                if (gt[j] >= j) {
                    int n = j;
                    gt[n] = gt[n] + 1;
                }
                ++j;
            }
            GeneralStringGenotype genotype = new GeneralStringGenotype(gt, numChar);
            result[0].addIndividual(new Individual(this.graph.getSchedule(), genotype, new Individual[0]));
            ++i;
        }
        return result;
    }

    public String getName() {
        return "SSSP Initialization";
    }

    public String getDescription() {
        return "This initialization differs from the random initialization on general strings in only one point. Namely, there will be no indices i such that x_i is set to i";
    }

    public Integer getPropertySize() {
        return new Integer(this.size);
    }

    public void setPropertySize(Integer no) {
        if (no > 0) {
            this.size = no;
        }
    }

    public String getLongDescriptionForSize() {
        return "The number of individuals to be created.";
    }
}

