% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFTuning.R
\name{optimizeMTRY}
\alias{optimizeMTRY}
\title{Mtry Optimization}
\usage{
optimizeMTRY(oob_matrix)
}
\arguments{
\item{oob_matrix}{a n x p of n OOB error values (one for each iteration) and p columns (one for each mtry value tested)
Each value of a column is the oob error of a model growth with a particular mtry. Typically for each mtry,
we will have N different models (N > 30), a sample large enough to provide an estimate of the average OOB
error for the corresponding population of models.}
}
\value{
a list of two elements: \itemize{
\item mean_matrix a 1 x p matrix which contains the mean of each OOB errors sample (resulting from the training of N different Random Forest models growth
with N different mtry values) 
\item ci_matrix a 2 x p matrix in which each column represents the 95\% confidence interval of the mean of the population of the OOB errors for each 
mtry value 
\item sd_matrix a 1 x p matrix which contains the standard deviatiaon of each OOB error sample resulting from the training of N different models
built for each value of mtry}
}
\description{
This function provides a 'population' estimate of the average OOB error computed for different mtry values,
starting from a sample of N models. These values will be used to compute the mtry associated to the minimum averaged OOB error,
that is the optimal parameter we are looking for.
}
\examples{
## data(cachexiaData)
## res <- tuneMTRY(cachexiaData, iterations = 50, maxntree = 600, mtry_length = 10, graph = F)
## l <- optimizeMTRY(res$oob)
}
\author{
Piergiorgio Palla
}

