% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFc.R
\name{fcGrid}
\alias{fcGrid}
\title{Fetches gridded data}
\usage{
fcGrid(variable, latitudeFrom, latitudeTo, latitudeBy, longitudeFrom,
  longitudeTo, longitudeBy, firstYear = 1961, lastYear = 1990,
  firstDay = 1, lastDay = 365, startHour = 0, stopHour = 24,
  url = "http://fetchclimate2.cloudapp.net/", dataSets = "ANY",
  reproduceFor = "NOW", verbose = F)
}
\arguments{
\item{variable}{An identifier of the variable to fetch. \cr
To get the list of available variables use `fcVariables()` function or see "Available data" section of documentaion}

\item{latitudeFrom}{A numeric scalar. The lower latitude bound of the spatial grid}

\item{latitudeTo}{A numeric scalar. The upper latitude bound of the spatial grid}

\item{latitudeBy}{A numeric scalar. The step of the grid along latitudes}

\item{longitudeFrom}{A numeric scalar. The lower longitude bound of the spatial grid}

\item{longitudeTo}{A numeric scalar. The upper longitude bound of the spatial grid}

\item{longitudeBy}{A numeric scalar. The step of the grid along longitudes.}

\item{firstYear}{A numeric scalar. Temporal coverage definition: The lower bound of years over which the averaging is performed}

\item{lastYear}{A numeric scalar. Temporal coverage definition: The upper bound of years over which the averaging is performed}

\item{firstDay}{A numeric scalar. Temporal coverage definition: The lower bound of the days interval within each year over which the averaging is performed}

\item{lastDay}{A numeric scalar. Temporal coverage definition: The upper bound of the days interval within each year over which the averaging is performed}

\item{startHour}{A numeric scalar. Temporal coverage definition: The lower bound of the hours interval within each day over which the averaging is performed}

\item{stopHour}{A numeric scalar. Temporal coverage definition: The upper bound of the hours interval within each day over which the averaging is performed}

\item{url}{The URL of the service to query the data from}

\item{dataSets}{A character vector. An identifier of the data set to fetch the data from. The special value "ANY" enables data stitching from all available data sets.}

\item{reproduceFor}{A character scalar. A string containing the time for which the result must correspond. The format is "YYYY-MM-DD". The special value "NOW" fetch the data using the latest FetchClimate configuration available.}

\item{verbose}{A logical scalar. If set to TRUE the method outputs its actions verbosely}
}
\value{
Type: SpatialPixelsDataFrame (from sp package)
Contains a grid definition the following fields: values, sd, provenance
}
\description{
Fetches gridded data
}
\examples{
#Fetching average potential evapotransiration for the upper part of Africa continent
#for Januries 2000-2010
#With 1 degree grid resolution

fcGrid(variable="pet",
     latitudeFrom=0, latitudeTo=35,latitudeBy=1,
     longitudeFrom= -25, longitudeTo=50, longitudeBy=1,
     firstDay=1,lastDay=31,
     firstYear=2000,lastYear=2010)
}

