% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t2S.R
\name{t2S}
\alias{t2S}
\title{Compute the robust effect size index estimate from t statistic (default)}
\usage{
t2S(t, rdf, n, unbiased = TRUE)
}
\arguments{
\item{t}{The t statistic for the parameter of interest.}

\item{rdf}{Model residual degrees of freedom/degrees of freedom of the t statistic.}

\item{n}{Number of independent samples.}

\item{unbiased}{Logical, whether to use unbiased or alternative estimator. See details.}
}
\value{
Returns a scalar or vector argument of the robust effect size index estimate.
}
\description{
This function computes the robust effect size index from Vandekar, Tao, & Blume (2020).
Vector arguments are accepted. If different length arguments are passed they are dealt with in the usual way of R.
}
\details{
This function computes S, the RESI, from a t statistic. The formula for the
unbiased estimator (default) is derived by solving the expected value of the
t statistic for S. It is unbiased and consistent.

The formula for the unbiased conversion is:

\eqn{S = (t * \sqrt(2) * \Gamma(rdf/2)) / (\sqrt(n * rdf) * \Gamma((rdf - 1)/2))}

The formula for the alternative estimator is derived by squaring the t statistic
and using the \code{\link{f2S}} formula. This estimator may be appealing for its
intuitive relationship to the F statistic; the absolute value of RESI estimates
using this formula will be equal to a RESI estimate using an F statistic for
the same model. However, this estimator does have finite sample bias, which is an
important consideration for the coverage of the bootstrapping that \code{resi} uses.

The formula for the alternative conversion is:

\eqn{ \sqrt(max(0, (t^2 * (rdf - 2)/rdf - 1)/rdf))}
}
\examples{
# to obtain t values, first fit a lm
mod = lm(charges ~ region * age + bmi + sex, data = RESI::insurance)
# run lmtest::coeftest to get t values, using a robust variance-covariance formula
ts = lmtest::coeftest(mod, vcov. = sandwich::vcovHC)[,'t value']

# get RESI estimates using unbiased estimator
t2S(ts, n = nrow(RESI::insurance), rdf = mod$df.residual)

# get RESI estimates using alternative estimator
t2S(ts, n = nrow(RESI::insurance), rdf = mod$df.residual, unbiased = FALSE)
}
