% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omnibus.R
\name{omnibus}
\alias{omnibus}
\title{Omnibus (Overall) Wald Test for resi objects}
\usage{
omnibus(object, alpha = NULL, ...)
}
\arguments{
\item{object}{an object resulting from resi function}

\item{alpha}{an optional new specification for the confidence level. Can be vector-valued}

\item{...}{ignored}
}
\value{
Returns a `omnibus_resi` object containing the computed omnibus Wald test
}
\description{
After running the \code{\link{resi}} function on a fitted model, this function
can be used to print the overall Wald test component. If the resi function was run
with the `store.boot = TRUE` option to store the full matrix of bootstrapped estimates,
the user can specify a different alpha level for this function's confidence intervals.
}
\examples{
# fit a model
mod = lm(charges ~ bmi + sex, data = RESI::insurance)

# run resi with the store.boot = TRUE option
resi_obj = resi(mod, nboot = 100, store.boot = TRUE, alpha = 0.01)

# run summary, specifying a different alpha level if desired
omnibus(resi_obj, alpha = 0.05)
}
