% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{JunInfo}
\alias{JunInfo}
\title{JunInfo}
\usage{
JunInfo(x, ASPSR, JLines, TrLines, ELines, DataS, Groups,
  Low_AllSamples = c(), Low_GSamples = c(), Plot, Name)
}
\arguments{
\item{x}{The TC ID for which to retrieve and asses the junction information .}

\item{ASPSR}{The AS probe sets as identified by ASExons.}

\item{JLines}{The lines which contain information on the TC ID in the junction association file.}

\item{TrLines}{The lines which contain information on the TC ID in the transcript annotation file.}

\item{ELines}{The lines which contain information on the TC ID in the exon annotation file.}

\item{DataS}{The TC ID subset of the probe level data.}

\item{Groups}{A list with  elements speficifing the columns of the data in each group.}

\item{Low_AllSamples}{A character vector containing the probe sets which are not DABG in all samples.}

\item{Low_GSamples}{A list with a  character vector per group containing the probe sets which are not DABG in that group.}

\item{Plot}{Should a plot of the gene model be made?}

\item{Name}{A character string with the name of the ouput file.}
}
\value{
The function returns three files. The first file has name "Name.txt" and contains a line per probe set. It shows the reached decision
regarding the probe set (const/AS/not DABG),its linking and exclusion junctions, the fold change, the AS type and its annotated exons. The second
file is a list of all found transcripts for a particular TC I. The third file indicates whether a specific transcript is present or absent in a group.
}
\description{
JunInfo functions asses the junction information for a single gene
}
\details{
The plot is produced by the arcplot function of the arcdiagram package (https://github.com/gastonstat/arcdiagram)
}
