% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_insert_na.R
\name{rd_insert_na}
\alias{rd_insert_na}
\title{Insert missing using a filter}
\usage{
rd_insert_na(data, filter, vars)
}
\arguments{
\item{data}{Database containing data from REDCap.}

\item{filter}{Character vector containing the logic to be directly evaluated.}

\item{vars}{Character vector containing the names of those variables to transform. When the previous evaluated logic is `TRUE` the variables in the same event will be transformed to missing. So, remember that the variables in the filter have to be in the same event as the othe variables.}
}
\value{
transformed data with the specified variables converted.
}
\description{
Function that allows you to manually input a missing to some variables (`vars`) when some filters (`filter`) are satisfied. Useful for checkboxes without a gatekeeper question in the branching logic. Advert that the variables present in the filter have to be in the same event as the variables we want to convert.
}
\examples{
data <- rd_transform(data = covican$data,
                     dic = covican$dictionary)$data

rd_insert_na(data = data,
             filter = rep("age < 65", 2),
             vars = grep("type_underlying_disease", names(data), value = TRUE))
}
