% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KFME_grid.R
\name{KFME_grid}
\alias{KFME_grid}
\title{KFME grid cells (faunistické čtverce) of the Czech Republic}
\usage{
KFME_grid(resolution = "low")
}
\arguments{
\item{resolution}{Should the function return high or low resolution shapefile? Allowed values are "low" and "high". Default is "low".}
}
\value{
\code{sf} data frame with 1092 rows in low resolution and 4368 rows in high resolution

\describe{
\item{ctverec}{KFME code of the grid cell; depending on value of \code{resolution} parameter either 4 digits, or 4 digits + 1 letter}
}
}
\description{
Function returning grid covering the Czech Republic according to the Kartierung der Flora Mitteleuropas methodology.
}
\details{
The function returns a \code{sf} data frame of grid cells. Depending on the value of parameter \code{resolution} either low resolution (26×42 cells - default) with labels in 4 digit format (e.g. Hrčava = 6479) or high resolution (104×168 cells) with labels in 4 digit + 1 letter format (e.g Hrčava = 6479c).

Raw version of the dataset is available for download for use in non-R setting on \url{https://rczechia.jla-data.net/kfme_czechia.gpkg}.
}
\examples{
library(ggplot2)

ggplot() +
  geom_sf(data = republika("low")) +
  geom_sf(data = KFME_grid("low"), fill = NA)

}
