% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_lambda_group}
\alias{calculate_lambda_group}
\title{calculates factor loadings of groupfactors}
\usage{
calculate_lambda_group(
  robust,
  Y,
  X,
  beta_est,
  factor_group,
  g,
  lambda,
  comfactor,
  S,
  k,
  kg,
  method_estimate_beta = "individual",
  method_estimate_factors = "macro",
  verbose = FALSE,
  initialise = FALSE
)
}
\arguments{
\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{factor_group}{estimated group specific factors}

\item{g}{Vector with estimated group membership for all individuals}

\item{lambda}{loadings of the estimated common factors}

\item{comfactor}{estimated common factors}

\item{S}{number of estimated groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{method_estimate_factors}{defines method of robust estimaton of the factors: "macro", "pertmm" or "cz"}

\item{verbose}{when TRUE, it prints messages}

\item{initialise}{indicator of being in the initialisation phase}
}
\value{
Returns a data.frame with a row for each time series. The first number of columns contain the individual loadings to the group specific factors.
Furthermore "group" (group membership) and id (the order in which the time series appear in Y) are added.
}
\description{
returns object which includes group and id of the individuals
}
