% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO-download.R
\name{processAffymetrix}
\alias{processAffymetrix}
\title{Process and normalize affymetrix-based dataset}
\usage{
processAffymetrix(dir, samples = NULL)
}
\arguments{
\item{dir}{The path to the directory containing CEL files.}

\item{samples}{A vector of samples IDs. If NULL, the function will automatically detect the samples in the directory.}
}
\value{
A matrix of normalized expression data. Rows are probes and columns are samples.
}
\description{
This function process CEL files and normalize expression data
}
\details{
Read and normalize expression data for affymetrix using RMA method
}
\examples{
\donttest{
library(RCPA)
geoId <- "GSE59761"
downloadPath <- file.path(tempdir(), geoId)
fileList <- RCPA::downloadGEO(GEOID = geoId, protocol = "affymetrix",
                               platform ="GPL16311", destDir = downloadPath)
# process only 3 samples
expression <- RCPA::processAffymetrix(downloadPath, 
                   samples = c("GSM1446171", "GSM1446172", "GSM1446173"))
}
}
