% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveNetCDF.R
\name{saveNetCDF}
\alias{saveNetCDF}
\title{Save a cmip5data object to NetCDF format}
\usage{
saveNetCDF(x, file = NULL, path = "./", verbose = FALSE,
  saveProvenance = TRUE, originalNames = FALSE)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{file}{Filename; if omitted one will be generated automatically.}

\item{path}{File path.}

\item{verbose}{logical. Print info as we go?}

\item{saveProvenance}{Save the provenance separately?}

\item{originalNames}{logical. Use original dimension names from file?}
}
\value{
The fully-qualified filename that was written (invisible).
}
\description{
There are at least three ways to save a \code{\link{cmip5data}} object.
First, \link{save} it. Second, use \link{as.data.frame} or \link{as.array}.
Third, this function, which will write out a new NetCDF file readable by 
any NetCDF-aware software.
}
\details{
If no filename is provided, a meaningful one will be assigned based on 
the CMIP5 naming convention (but appending 'RCMIP5'). The \code{\link{loadCMIP5}} 
function should be able to read this file. If \code{saveProvenance} is specified, 
the provenance is saved separately in a comma-separated file of the same name but
appending "_prov.csv". (Provenance messages are always saved as NetCDF file attributes.)
}
\note{
This function requires the \code{ncdf4} package; \code{ncdf} is not supported.
}

