% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{paste_noun_pp}
\alias{paste_noun_pp}
\title{Recombine row and column labels}
\usage{
paste_noun_pp(
  splt_labels,
  notation = RCLabels::bracket_notation,
  squish = TRUE
)
}
\arguments{
\item{splt_labels}{A vector of split row or column labels, probably created by \code{split_noun_pp()}.}

\item{notation}{The notation object that describes the labels.
Default is \code{RCLabels::bracket_notation}.}

\item{squish}{A boolean that tells whether to remove extra spaces in the output of \verb{paste_*()} functions.
Default is \code{TRUE}.}
}
\value{
Recombined row and column labels.
}
\description{
This function recombines (unsplits) row or column labels that have
been separated by \code{split_noun_pp()}.
}
\examples{
labs <- c("a [of b in c]", "d [from Coal mines in USA]")
labs
split <- split_noun_pp(labs)
split
paste_noun_pp(split)
# Also works in a data frame
df <- tibble::tibble(labels = c("a [in b]", "c [of d into USA]",
                                "e [of f in g]", "h [-> i in j]"))
recombined <- df \%>\%
  dplyr::mutate(
    splits = split_noun_pp(labels),
    recombined = paste_noun_pp(splits)
  )
all(recombined$labels == recombined$recombined)
}
