% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters.R
\name{remove_label_pieces}
\alias{remove_label_pieces}
\title{Remove a prepositional phrase in a row or column label}
\usage{
remove_label_pieces(
  labels,
  pieces_to_remove,
  prepositions = RCLabels::prepositions,
  notation = RCLabels::bracket_notation
)
}
\arguments{
\item{labels}{The row and column labels from which prepositional phrases will be removed.}

\item{pieces_to_remove}{The names of pieces of the label to be removed,
typically "noun" or a preposition such as "of" or "in"
See \code{RCLabels::prepositions} for a list of known prepositions.}

\item{prepositions}{A list of prepositions, used to detect prepositional phrases.
Default is \code{RCLabels::prepositions}.}

\item{notation}{The notation used in \code{labels}.
Default is \code{RCLabels::bracket_notation}.}
}
\value{
\code{labels} with pieces removed.
}
\description{
This function removes pieces from
row and column labels.
}
\examples{
labs <- c("a [of b in c]", "d [-> e in f]")
remove_label_pieces(labs, pieces_to_remove = "of")
remove_label_pieces(labs, pieces_to_remove = c("of", "->"))
remove_label_pieces(labs, pieces_to_remove = c("in", "into"))
remove_label_pieces(labs, pieces_to_remove = c("of", "in"))
}
