% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBMRB.R
\name{convert_cs_to_n15hsqc}
\alias{convert_cs_to_n15hsqc}
\title{Reformats chemical shift dataframe for easy plotting}
\usage{
convert_cs_to_n15hsqc(csdf)
}
\arguments{
\item{csdf}{Chemical shift data frame from \link{fetch_entry_chemical_shifts}}
}
\value{
R data frame that contains proton and nitrogen chemical shifts in two columns for each residue
}
\description{
Reformats the output dataframe from \link{fetch_entry_chemical_shifts} into a simple dataframe that contains algorithmically combined proton and nitrogen chemical shifts in two columns.
This will be helpful to plot 1H-15N HSQC(Hetronuclear Single Quantum Coherence) spectrum.
}
\examples{
df<-fetch_entry_chemical_shifts(15060)
#Downloads the chemical shift data from BMRB
hsqc<-convert_cs_to_n15hsqc(df)
#Reformats for easy plotting
}
\seealso{
\code{\link{convert_cs_to_c13hsqc}} and \code{\link{convert_cs_to_tocsy}}
}

