% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition.R
\name{rah_condition}
\alias{rah_condition}
\title{Single condition creation for an Ahrefs API query}
\usage{
rah_condition(column_name, operator, value, is_date = FALSE)
}
\arguments{
\item{column_name}{character string. Proper name of the column of the raport to query from}

\item{operator}{character string. See more in details}

\item{value}{character string or numeric/integer. Contains the value for a condition}

\item{is_date}{logical, defaults to FALSE. If provided value is a date character string,
should be set to TRUE. Works only for dates in \code{'YYYY-MM-DD'} format.}
}
\value{
character string with formatted condition
}
\description{
This function create an optional single condition for report querying.
    It can only be used in \code{where} and \code{having} parameters and should only be used
    inside \code{rah_condition_set} function.
}
\details{
This function should be ALWAYS used inside \code{rah_condition_set} function.
    Options include:
    \itemize{

      \item \strong{"SUBDOMAIN"} (string) the condition is satisfied if a domain in the \code{<column>}
          is a subdomain of the provided \code{<domain>}, for example:
          \code{rah_condition("url_to", "SUBDOMAIN", "dev")}

      \item \strong{"SUBSTRING"} (string) the condition is satisfied if the provided \code{<value>}
          is a substring of the \code{<column>}, for example:
          \code{rah_condition("url_to", "SUBSTRING", "ample")}

      \item \strong{"WORD"} (string) the condition is satisfied if the provided \code{<value>} appears
          as a separate word of the \code{<column>}, for example:
          \code{rah_condition("title", "WORD", "the")}

      \item \strong{"EQUALS", "UNEQUALS", "LESS_THAN", "LESS_OR_EQUAL", "GREATER_THAN", "GREATER_OR_EQUAL"}
          (numeric/date) the condition is satisfied if a \code{<column>} is different to \code{<value>},
           for example: \code{rah_condition("domain_rank", "GREATER_OR_EQUAL", 5)} \strong{OR} for dates
          \code{rah_condition("first_seen", "LESS_THAN", "2019-01-01", is_date = TRUE)}
    }
}
\examples{
    \dontrun{rah_condition(column_name = "first_seen",
                           operator = "GREATER_THAN",
                           value = "2018-01-01",
                           is_date = TRUE)
 }
    \dontrun{rah_condition(column_name = "links",
                           operator = "GREATER_THAN",
                           value = "10")
}
}
\seealso{
Other Ahrefs conditions: \code{\link{rah_condition_set}}
}
\concept{Ahrefs conditions}
