% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMM_functions_cpp.R
\name{EM3.op}
\alias{EM3.op}
\title{Equation of mixed model for multi-kernel using other packages (much faster than EM3.cpp)}
\usage{
EM3.op(
  y,
  X0 = NULL,
  ZETA,
  eigen.G = NULL,
  package = "gaston",
  tol = NULL,
  n.core = 1,
  REML = TRUE,
  pred = TRUE,
  return.u.always = TRUE,
  return.u.each = TRUE,
  return.Hinv = TRUE
)
}
\arguments{
\item{y}{A \eqn{n \times 1} vector. A vector of phenotypic values should be used. NA is allowed.}

\item{X0}{A \eqn{n \times p} matrix. You should assign mean vector (rep(1, n)) and covariates. NA is not allowed.}

\item{ZETA}{A list of variance matrices and its design matrices of random effects. You can use more than one kernel matrix.
For example, ZETA = list(A = list(Z = Z.A, K = K.A), D = list(Z = Z.D, K = K.D)) (A for additive, D for dominance)
Please set names of lists "Z" and "K"!}

\item{eigen.G}{A list with
\describe{
\item{$values}{Eigen values}
\item{$vectors}{Eigen vectors}
}
The result of the eigen decompsition of \eqn{G = ZKZ'}. You can use "spectralG.cpp" function in RAINBOWR.
If this argument is NULL, the eigen decomposition will be performed in this function.
We recommend you assign the result of the eigen decomposition beforehand for time saving.}

\item{package}{Package name to be used in this function. We only offer the following three packages:
"RAINBOWR", "MM4LMM" and "gaston". Default package is `gaston`.}

\item{tol}{The tolerance for detecting linear dependencies in the columns of G = ZKZ'.
Eigen vectors whose eigen values are less than "tol" argument will be omitted from results.
If tol is NULL, top 'n' eigen values will be effective.}

\item{n.core}{Setting n.core > 1 will enable parallel execution on a machine with multiple cores (only for `MM4LMM`).}

\item{REML}{You can choose which method you will use, "REML" or "ML".
If REML = TRUE, you will perform "REML", and if REML = FALSE, you will perform "ML".}

\item{pred}{If TRUE, the fitting values of y is returned.}

\item{return.u.always}{When using the "gaston" package with missing values or
using the "MM4LMM" package (with/without missings), computing BLUP will take
some time in addition to solving the mixed-effects model. You can choose
whether BLUP (`u`; \eqn{u}) will be returned or not.}

\item{return.u.each}{If TRUE, the function also computes each BLUP corresponding
to different kernels (when solving multi-kernel mixed-effects model). It takes
additional time compared to the one with `return.u.each = FALSE`.}

\item{return.Hinv}{If TRUE, \eqn{H ^ {-1} = (Var[y] / \sum _{l=1} ^ {L} \sigma _ {l} ^ 2) ^ {-1}}
will be computed. It also returns \eqn{V ^ {-1} = (Var[y]) ^ {-1}}.
It will take some time in addition to solving the mixed-effects model.}
}
\value{
\describe{
\item{$y.pred}{The fitting values of y \eqn{y = X\beta + Zu}}
\item{$Vu}{Estimator for \eqn{\sigma^2_u}, all of the genetic variance}
\item{$Ve}{Estimator for \eqn{\sigma^2_e}}
\item{$beta}{BLUE(\eqn{\beta})}
\item{$u}{BLUP(Sum of \eqn{Zu})}
\item{$u.each}{BLUP(Each \eqn{u})}
\item{$weights}{The proportion of each genetic variance (corresponding to each kernel of ZETA) to Vu}
\item{$LL}{Maximized log-likelihood (full or restricted, depending on method)}
\item{$Vinv}{The inverse of \eqn{V = Vu \times ZKZ' + Ve \times I}}
\item{$Hinv}{The inverse of \eqn{H = ZKZ' + \lambda I}}
}
}
\description{
This function solves the following multi-kernel linear mixed effects model
using \code{\link[MM4LMM]{MMEst}} function in `MM4LMM` package,
\code{\link[gaston]{lmm.aireml}} or \code{\link[gaston]{lmm.diago}} functions in `gaston` package,
or \code{\link[RAINBOWR]{EM3.cpp}} function in `RAINBOWR` package.

\eqn{y = X \beta + \sum _{l=1} ^ {L} Z _ {l} u _ {l} + \epsilon}

where \eqn{Var[y] = \sum _{l=1} ^ {L} Z _ {l} K _ {l} Z _ {l}' \sigma _ {l} ^ 2 + I \sigma _ {e} ^ {2}}.
}
\references{
Kang, H.M. et al. (2008) Efficient Control of Population Structure
 in Model Organism Association Mapping. Genetics. 178(3): 1709-1723.

Zhou, X. and Stephens, M. (2012) Genome-wide efficient mixed-model analysis
 for association studies. Nat Genet. 44(7): 821-824.

Johnson, D. L., & Thompson, R. (1995). Restricted maximum likelihood estimation of variance
components for univariate animal models using sparse matrix techniques and average information.
Journal of dairy science, 78(2), 449-456.

Hunter, D. R., & Lange, K. (2004). A tutorial on MM algorithms.
The American Statistician, 58(1), 30-37.

Zhou, H., Hu, L., Zhou, J., & Lange, K. (2015). MM algorithms for variance components models.
arXiv preprint arXiv:1509.07426.

Gilmour, A. R., Thompson, R., & Cullis, B. R. (1995), Average information REML:
an efficient algorithm for variance parameter estimation in linear mixed models,
Biometrics, 1440-1450.
}
\seealso{
\code{\link[MM4LMM]{MMEst}}, \code{\link[gaston]{lmm.aireml}}, \code{\link[gaston]{lmm.diago}}
}
