% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{run_rafs}
\alias{run_rafs}
\title{Robust Aggregative Feature Selection (RAFS)}
\usage{
run_rafs(
  data,
  decision,
  k = 5,
  seeds = sample.int(32767, 10),
  fs_fun = default_fs_fun,
  dist_funs = default_dist_funs,
  hclust_methods = default_hclust_methods
)
}
\arguments{
\item{data}{input data where columns are variables and rows are observations (all numeric)}

\item{decision}{decision variable as a binary sequence of length equal to number of observations}

\item{k}{number of folds for internal cross validation}

\item{seeds}{a vector of seeds used for fold generation for internal cross validation}

\item{fs_fun}{function to compute feature selection p-values, it must have the same signature as \code{\link{default_fs_fun}} (which is the default, see its help to learn more)}

\item{dist_funs}{a list of feature dissimilarity functions computed over the relevant portion of the training dataset (see the example \code{\link{default_dist_funs}} and \code{\link{builtin_dist_funs}} to learn more)}

\item{hclust_methods}{a vector of \code{\link{hclust}} methods to use}
}
\value{
A nested \code{\link{list}} with \code{\link{hclust}} results.
  The first level is per the cross validation run.
  The second level is per the feature dissimilarity function.
  The third (and last) level is per the hclust method.
}
\description{
This is the main function of the RAFS library to run for analysis.
}
\details{
Depending on your pipeline, you may want to also check out \code{\link{run_rafs_with_fs_results}} and \code{\link{compute_fs_results}}
which this function simply wraps over.

The results from this function can be fed into one of the helper functions
to analyse them further: \code{\link{get_rafs_reps_popcnts}},
\code{\link{get_rafs_rep_tuples_popcnts}},
\code{\link{get_rafs_rep_tuples_matrix}} and
\code{\link{get_rafs_occurrence_matrix}}.
}
\examples{
library(MDFS)
mdfs_omp_set_num_threads(1)  # only to pass CRAN checks
data(madelon)
run_rafs(madelon$data, madelon$decision, 2, c(12345))
}
