% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cdbAddAttachment}
\alias{cdbAddAttachment}
\title{Add attachments}
\usage{
cdbAddAttachment(cdb)
}
\arguments{
\item{cdb}{The list \code{cdb} has to contain
\code{cdb$fileName},\code{cdb$serverName}, \code{cdb$DBName} and a
\code{cdb$id}.}
}
\value{
\item{cdb}{The result is stored in \code{cdb$res} }
}
\description{
This function adds attachments to a database document that already
exists.
}
\details{
The function uses the  \code{RCurl}- function
\code{guessMIMEType()} to do exactly this: guessing the mime type of
\code{cdb$fileName}.

If the switch \code{cdb$attachmentsWithPath} is set to \code{TRUE}
the attachment is saved with the path. This behavior is default
since version 0.2.5 of R4CouchDB
}
\examples{
\dontrun{
ccc            <- cdbIni(DBName="r4couch_db")
ccc$dataList   <- list(normalDistRand =  rnorm(20))
ccc            <- cdbAddDoc(ccc)
# make a 3d plot (stolen from ?persp)
x              <- seq(-10, 10, length= 30)
y              <- x
f              <- function(x,y) {r <- sqrt(x^2+y^2); 10 * sin(r)/r }
z              <- outer(x, y, f)

z[is.na(z)]    <- 1
op             <- par(bg = "black")
ccc$fileName   <- "3dplot.pdf"

pdf(ccc$fileName)
persp(x, y, z,
      theta = 30,
      phi = 30,
      expand = 0.5,
      col = "lightblue")
dev.off()
# add the plot as attachment to the database
# it workes over  ccc$fileName
ccc            <- cdbAddAttachment(ccc)
}
}
\author{
wactbprot
}
\keyword{misc}

