% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mmatrix.R
\name{get.Mmatrix}
\alias{get.Mmatrix}
\title{Calculate \eqn{\mathbf{M}} matrix}
\usage{
get.Mmatrix(K = NULL, pattern = NULL)
}
\arguments{
\item{K}{The number of attributes. Can be \code{NULL} if the argument \code{pattern} is not \code{NULL}.}

\item{pattern}{The attribute mastery pattern matrix containing all possible attribute mastery pattern.
Can be gained from \code{\link[GDINA]{attributepattern}}. Also can be \code{NULL} if \code{K}
is not \code{NULL}.}
}
\value{
An object of class \code{matrix}.
}
\description{
Calculate \eqn{\mathbf{M}} matrix for stauted CDMs (de la Torre, 2011). The \eqn{\mathbf{M}} matrix is a matrix used to 
represent the interaction mechanisms between attributes.
}
\examples{

library(Qval)

example.Mmatrix <-  get.Mmatrix(K = 3)

}
\references{
de la Torre, J. (2011). The Generalized DINA Model Framework. Psychometrika, 76(2), 179-199. DOI: 10.1007/s11336-011-9207-7.
}
\author{
Haijiang Qin <Haijiang133@outlook.com>
}
