% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0setS4_QuantileGH.R
\docType{class}
\name{fmx_QLMDe-class}
\alias{fmx_QLMDe-class}
\title{Specification of \code{\linkS4class{fmx_QLMDe}} Class}
\description{
Quantile least Mahalanobis distance estimates (\code{\link{QLMDe}}) of finite mixture distribution, with the one-dimensional observations included.
The \code{\linkS4class{fmx_QLMDe}} object contains (i.e., inherits from) the \code{\linkS4class{fmx}} object.
}
\section{Slots}{

\describe{
\item{\code{data}}{\code{\link[base]{numeric}} vector of the one-dimensional observations}

\item{\code{data.name}}{\code{\link[base]{character}} scalar for the name of observations}

\item{\code{epdf}}{empirical probability density \code{\link[base]{function}} fitted by \code{\link[stats]{approxfun}}}

\item{\code{quantile_vv}}{variance-covariance \code{\link[base]{matrix}} of selected quantiles (based on the selected probabilities stored in slot \code{@p})}

\item{\code{init}}{\code{\linkS4class{fmx}} object indicating the initial values to be sent to \code{\link[stats]{optim}}}

\item{\code{p}}{\code{\link[base]{numeric}} vectors of probabilities, where the distance between the empirical and true quantiles will be measured}

\item{\code{optim}}{a \code{\link[base]{list}} returned from \code{\link[stats]{optim}}}
}}

\examples{
?`fmx_QLMDe-class`

}
