% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reAssign.R
\name{reAssign}
\alias{reAssign}
\title{Re-Assign Observations Trimmed Prior to Clustering}
\usage{
reAssign(x, ...)
}
\arguments{
\item{x}{a trimmed clustering object}

\item{...}{potential parameters}
}
\value{
An \code{'reAssign_tkmeans'} object inheriting from class \code{'tkmeans'}, 
which is the returned object class of \code{\link[tclust]{tkmeans}}.
}
\description{
Re-assign observations trimmed prior to clustering using \eqn{k}-means algorithm 
(via \code{\link[tclust]{tkmeans}}) to the closest cluster (at the smallest 
Mahalanobis distance).
}
\examples{
library(tclust)
data(geyser2)
clus = tkmeans(geyser2, k = 3L, alpha = .03)
plot(clus, main = 'Before Re-Assigning')
plot(reAssign(clus), main = 'After Re-Assigning')

}
