% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{bw}
\alias{bw}
\alias{bw}
\alias{\%bw\%}
\title{Check if values are between specified interval}
\usage{
bw(x, interval)

x \%bw\% interval
}
\arguments{
\item{x}{vector}

\item{interval}{vector of length 1 or 2, see 'Examples' section}
}
\description{
Check if values are between specified interval
}
\details{
If second element of interval contains time selection is closed on the left only (\code{a <= x < b}) otherwise selection is closed (\code{a <= x <= b}).
}
\examples{
\donttest{

data( ticks )

# bw is very usefull to filter time series data:
# select single year
ticks[ time \%bw\% '2016' ]

# select single month
ticks[ time \%bw\% '2016-05' ]

# select single date
ticks[ time \%bw\% '2016-05-11' ]
# also works with Date class
ticks[ time \%bw\% as.Date( '2016-05-11' ) ]

# select single hour
ticks[ time \%bw\% '2016-05-11 10' ]

# select single minute
ticks[ time \%bw\% '2016-05-11 10:20' ]

# select single second
ticks[ time \%bw\% '2016-05-11 10:20:53' ]

# select between two months inclusive
ticks[ time \%bw\% c( '2016-05', '2016-08' ) ]

# select from month begin and date
ticks[ time \%bw\% c( '2016-05', '2016-06-23' ) ]

# select between two timestamps
ticks[ time \%bw\% c( '2016-05-02 09:30', '2016-05-02 11:00' ) ]
# also works with incomplete timestamps
ticks[ time \%bw\% c( '2016-05-02 09:30', '2016-05-02 11' ) ]

# select all dates but with time between 09:30 and 16:00
ticks[ time \%bw\% c( '09:30', '16:00' ) ]

# also bw can be used as a shortcut for 'a <= x & x <= b' for non-'POSIXct' classes:
# numeric
15:25 \%bw\% c( 10, 20 )

# character
letters \%bw\% c( 'a', 'f' )

# dates
Sys.Date() \%bw\% ( Sys.Date() + c( -10, 10 ) )


}
}
