% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Quandlapi.R
\name{quandl.api}
\alias{quandl.api}
\title{Pulls Data from the Quandl API}
\usage{
quandl.api(version = "v1", path, http = c("GET", "PUT", "POST", "DELETE"),
  postdata = NULL, ...)
}
\arguments{
\item{version}{Set to the version of the Quandl API you want to access.}

\item{path}{Path to api resource.}

\item{http}{Type of http request sent.}

\item{postdata}{A character or raw vector that is sent in a body.}

\item{...}{Named values that are interpretted as api parameters.}
}
\value{
Website response.
}
\description{
An authentication token is needed for access to the Quandl API multiple times. Set your \code{access_token} with \code{Quandl.auth} function.
}
\details{
For instructions on finding your authentication token go to https://www.quandl.com/account
}
\examples{
\dontrun{
quandldata = quandl.api(version="v1", path="datasets/NSE/OIL", http="GET")
plot(quandldata[,1])
}
}
\author{
Raymond McTaggart
}
\references{
This R package uses the Quandl API. For more information go to https://www.quandl.com/help/api. For more help on the package itself go to http://www.quandl.com/help/r.
}
\seealso{
\code{\link{Quandl.auth}}
}

