#' PaluxyRiver Dinosaur Track Dataset
#'
#' A 'track' R object representing dinosaur tracks from the Paluxy River site.
#'
#' @format A list consisting of two elements:
#'   * **Trajectories**: A list of interpolated trajectories, where each trajectory is a series of midpoints between consecutive footprints.
#'   * **Footprints**: A list of data frames containing footprint coordinates, metadata (e.g., image reference, ID), and a marker indicating whether the footprint is actual or inferred.
#'
#' @source Farlow, J. O., O’Brien, M., Kuban, G. J., Dattilo, B. F., Bates, K. T., Falkingham, P. L., & Piñuela, L. (2012). Dinosaur Tracksites of the Paluxy River Valley (Glen Rose Formation, Lower Cretaceous), Dinosaur Valley State Park, Somervell County, Texas. In Proceedings of the V International Symposium about  Dinosaur Palaeontology and their Environment (pp. 41-69). Burgos: Salas de los Infantes.
"PaluxyRiver"

#' MountTom Dinosaur Track Dataset
#'
#' A 'track' R object representing dinosaur tracks from the Mount Tom site.
#'
#' @format A list consisting of two elements:
#'   * **Trajectories**: A list of interpolated trajectories, where each trajectory is a series of midpoints between consecutive footprints.
#'   * **Footprints**: A list of data frames containing footprint coordinates, metadata (e.g., image reference, ID), and a marker indicating whether the footprint is actual or inferred.
#'
#' @source Ostrom, J. H. (1972). Were some dinosaurs gregarious?. Palaeogeography, Palaeoclimatology, Palaeoecology, 11(4), 287-301.
"MountTom"
