% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSO.r
\name{plotQUALYPSOgrandmean}
\alias{plotQUALYPSOgrandmean}
\title{plotQUALYPSOgrandmean}
\usage{
plotQUALYPSOgrandmean(QUALYPSOOUT, iMedian = 7, iBinf = 2,
  iBsup = 12, lim = NULL, col = "black", xlab = "Years",
  ylab = "Grand mean", addLegend = T, ...)
}
\arguments{
\item{QUALYPSOOUT}{output from \code{\link{QUALYPSO}}}

\item{iMedian}{index corresponding to the median (Pr=0.5) in \code{QUALYPSOOUT$listOption$quantileCompress} (default=7)}

\item{iBinf}{index corresponding to the lower bound in \code{QUALYPSOOUT$listOption$quantileCompress} (default=2)}

\item{iBsup}{index corresponding to the upper bound in \code{QUALYPSOOUT$listOption$quantileCompress} (default=12)}

\item{lim}{y-axis limits (default is NULL)}

\item{col}{color for the overall mean and the credible interval}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{addLegend}{if TRUE, a legend is added}

\item{...}{additional arguments to be passed to \code{\link[graphics]{plot}}}
}
\description{
Plot prediction of grand mean ensemble. By default, we plot the credible interval corresponding to a probability 0.95.
}
\author{
Guillaume Evin
}
